% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xptr_create}
\alias{xptr_create}
\title{Create an external pointer to a C++ function}
\usage{
xptr_create(fstr)
}
\arguments{
\item{fstr}{A string indicating the C++ function required.}
}
\value{
The external pointer.
}
\description{
This function is used in \code{\link[itp]{itp-package}} to create
external pointers to the C++ functions used as examples to illustrate the
use of the function \code{\link{itp}}.  These pointers are passed as the
argument \code{f} to \code{\link{itp}}.  To create their own examples
the user will need to create their own C++ function a function that is
similar to \code{xptr_create}.
}
\details{
See the vignette
\href{https://paulnorthrop.github.io/itp/articles/itp-vignette.html}{
Overview of the itp package} and the file
\href{https://raw.githubusercontent.com/paulnorthrop/itp/main/src/user_fns.cpp}{
user_fns.cpp} for information.

The example C++ functions available in \code{itp} are: \code{"wiki"},
\code{"lambert"}, \code{"trig1"}, \code{"poly3"}, \code{"linear"},
\code{"warsaw"} and \code{staircase}.
}
\examples{
lambert_ptr <- xptr_create("lambert")
res <- itp(lambert_ptr, c(-1, 1))
}
\seealso{
\code{\link{xptr_eval}} for calling a C++ function using an
  external pointer.
}
