% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/start_event.R
\name{start_event}
\alias{start_event}
\title{Determine the starting point for each time series.}
\usage{
start_event(data, column = "Time", event = "Event", label = "start.event",
  label.event = NULL, order = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{column}{Test string, name of the column that describes the order
withing the time series. Default is "Time".}

\item{event}{A text string or vector indicating the columns that define the
unique time series. Default is "Event".}

\item{label}{The name of the new column with the start point of each time
series. Default is "start.event".}

\item{label.event}{In case \code{event} is not a single column, providing a
text string will add a column with this name that defines unique time
series. Default is NULL (no new column for time series is created).}

\item{order}{Logical: whether or not to order each time series.
Default is TRUE, maybe set to FALSE with large data frames that are already ordered.}
}
\value{
Data frame.
}
\description{
Determine the starting point for each time series.
}
\examples{
data(simdat)
head(simdat)
test <- start_event(simdat, event=c("Subject", "Trial"), label.event="Event")
head(test)
}
\author{
Jacolien van Rij
}

