% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{boundPvalue}
\alias{boundPvalue}
\title{Construct p-values for treatment effects under partial
identification}
\usage{
boundPvalue(bounds, bounds.resamples, n, m, type)
}
\arguments{
\item{bounds}{vector, bounds of the treatment effects under partial
identification.}

\item{bounds.resamples}{matrix, stacked bounds of the treatment
effects under partial identification. Each row corresponds to a
subset resampled from the original data set.}

\item{n}{integer, size of original data set.}

\item{m}{integer, size of resampled data sets.}

\item{type}{character. Set to 'forward' to construct the forward
confidence interval for the treatment effect bounds. Set to
'backward' to construct the backward confidence interval for
the treatment effect bounds. Set to 'both' to construct both
types of confidence intervals.}
}
\value{
If \code{type} is 'forward' or 'backward', a scalar p-value
    corresponding to the type of confidence interval is
    returned. If \code{type} is 'both', a vector of p-values
    corresponding to the forward and backward confidence intervals
    is returned.
}
\description{
This function estimates the p-value for the treatment effect under
partial identification. p-values corresponding to forward and
backward confidence intervals can be returned.
}
