% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{genTarget}
\alias{genTarget}
\title{Generating LP moments for IV-like estimands}
\usage{
genTarget(treat, m0, m1, target, target.weight0, target.weight1,
  target.knots0, target.knots1, late.Z, late.from, late.to, late.X, eval.X,
  genlate.lb, genlate.ub, data, splinesobj, pmodobj, pm0, pm1,
  point = FALSE, noisy = TRUE)
}
\arguments{
\item{treat}{variable name for treatment indicator. The name can be
provided with or without quotation marks.}

\item{m0}{one-sided formula for the marginal treatment response
function for the control group. Splines may also be
incorporated using the expression \code{uSpline}, e.g.
\code{uSpline(degree = 2, knots = c(0.4, 0.8), intercept =
TRUE)}. The \code{intercept} argument may be omitted, and is
set to \code{TRUE} by default.}

\item{m1}{one-sided formula for the marginal treatment response
function for the treated group. See \code{m0} for details.}

\item{target}{character, target parameter to be
estimated. Currently function allows for ATE (\code{'ate'}),
ATT (\code{'att'}), ATU (\code{'atu'}), LATE (\code{'late'}),
and generalized LATE (\code{'genlate'}).}

\item{target.weight0}{user-defined weight function for the control
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.weight1}{user-defined weight function for the treated
group defining the target parameter. See \code{target.weight0}
for details.}

\item{target.knots0}{user-defined set of functions defining the
knots associated with spline weights for the control group. The
arguments of the function should consist only of variable names
in \code{data}. If the knots are constant across all
observations, then the user can instead submit the vector of
knots instead of a function.}

\item{target.knots1}{user-defined set of functions defining the
knots associated with spline weights for the treated group. See
\code{target.knots0} for details.}

\item{late.Z}{vector of variable names used to define the LATE.}

\item{late.from}{baseline set of values of Z used to define the
LATE.}

\item{late.to}{comparison set of values of Z used to define the
LATE.}

\item{late.X}{vector of variable names of covariates to condition
on when defining the LATE.}

\item{eval.X}{numeric vector of the values to condition variables
in \code{late.X} on when estimating the LATE.}

\item{genlate.lb}{lower bound value of unobservable \code{u} for
estimating the generalized LATE.}

\item{genlate.ub}{upper bound value of unobservable \code{u} for
estimating the generalized LATE.}

\item{data}{\code{data.frame} or \code{data.table} used to estimate
the treatment effects.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}. This object is supposed to be a
dictionary of splines, containing the original calls of each
spline in the MTRs, their specifications, and the index used
for naming each basis spline.}

\item{pmodobj}{A vector of propensity scores.}

\item{pm0}{A list of the monomials in the MTR for d = 0.}

\item{pm1}{A list of the monomials in the MTR for d = 1.}

\item{point}{boolean, set to \code{FALSE} by default. \code{point}
refers to whether the partial or point identification is
desired. If set to \code{FALSE}, then the gamma moments are
returned, i.e. sample averages are taken. If set to
\code{TRUE}, then no sample averages are taken, and a matrix is
returned. The sample average of each column of the matrix
corresponds to a particular gamma moment.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}
}
\value{
A list containing either the vectors of gamma moments for
    \code{D = 0} and \code{D = 1}, or a matrix of individual gamma
    values for \code{D = 0} and \code{D = 1}. Additoinally, two
    vectors are returned. \code{xindex0} and \code{xindex1} list
    the variables that interact with the unobservable \code{u} in
    \code{m0} and \code{m1}. \code{uexporder0} and
    \code{uexporder1} lists the exponents of the unobservable
    \code{u} in each term it appears in.
}
\description{
This function takes in the IV estimate and its IV-like
specification, and generates a list containing the corresponding
point estimate, and the corresponding moments (gammas) that will
enter into the constraint matrix of the LP problem.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare MTR functions
formula1 = ~ 1 + u
formula0 = ~ 1 + u
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Declare propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate target gamma moments
genTarget(treat = "d",
          m0 = ~ 1 + u,
          m1 = ~ 1 + u,
          target = "atu",
          data = dtm,
          splinesobj = splinesList,
          pmodobj = propensityObj,
          pm0 = polynomials0,
          pm1 = polynomials1,
          point = FALSE)


}
