% Generated by roxygen2 (4.0.1): do not edit by hand
\name{new.SonarConnection}
\alias{new.SonarConnection}
\title{JSON Studio connection}
\usage{
new.SonarConnection(url, host, db, port = 27017, username = NULL,
  pwd = NULL, sdb = NULL, ssl = FALSE, anyCert = FALSE, krb = FALSE,
  mapCredentials = FALSE, secondaryPref = FALSE)
}
\arguments{
\item{url}{the url where JSON Studio can be accessed}

\item{host}{the hostname of the Mongo server, as it would be entered from
the JSON Studio login screen}

\item{db}{the name of the database you intend to access}

\item{port}{the port number where Mongo is running}

\item{username}{a username to log in to the database, if necessary}

\item{pwd}{a password to log in to the database, if necessary}

\item{sdb}{the name of a database to store JSON Studio-related collections}

\item{ssl}{TRUE to connect using SSL}

\item{anyCert}{TRUE to accept any SSL certificate}

\item{krb}{TRUE to authenticate using Kerberos}

\item{mapCredentials}{TRUE to map credentials to a functional user account
with which to access data}

\item{secondaryPref}{TRUE to allow connecting to a secondary of a replica
set and prefer a secondary if the host value passed in is a replica set}
}
\value{
A SonarConnection object to connect to the given Mongo database
  through JSON Studio, which can be used with \code{\link{sonarFind}} or
  \code{\link{sonarAgg}}.
}
\description{
Create a connection to a Mongo database through JSON Studio
}
\details{
This function returns a SonarConnection object which can be used with
\code{\link{sonarFind}} and \code{\link{sonarAgg}} to query a Mongo
database.

The parameters for this function are explained in greater detail in the
JSON Studio help page Using the Gateway.
}
\examples{
con <- new.SonarConnection('https://localhost:8443', 'localhost', 'test')
}
\seealso{
\url{http://jsonstudio.com/wp-content/uploads/2014/04/manual141/_build/html/index.html}
}
\keyword{connection}
\keyword{database}

