% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dm.addMutation}
\alias{dm.addMutation}
\title{Adds mutations to a demographic model}
\usage{
dm.addMutation(dm, lower.range, upper.range, fixed.value, par.new = T,
  new.par.name = "theta", parameter, group = 0, variance = 0)
}
\arguments{
\item{dm}{The demographic model to which mutations should be added}

\item{lower.range}{If you want to estimate the mutation rate, this
will be used as the smallest possible value.}

\item{upper.range}{If you want to estimate the mutation rate, this
will be used as the largest possible value.}

\item{fixed.value}{If specified, the mutation rate will not be
estimated, but assumed to be fixed at the given value.}

\item{par.new}{If 'TRUE' a new parameter will be created using the
arguments 'lower.range' and 'upper.range' or
'fixed.value'. It will be named 'new.par.name'.
If 'FALSE' the argument 'parameter'
will be evaluated instead.}

\item{new.par.name}{The name for the new parameter.}

\item{parameter}{Instead of creating a new parameter, you can also
set the mutation rate to an expression based on existing
parameters. For example setting this to "theta" will use
an parameter with name theta that you have previously
created. You can also use R expression here, so "2*theta"
or "5*theta+2*tau" (if tau is another parameter) will also
work (also it does not make much sense).}

\item{group}{Group of loci for with this feature is added. 0 means that
the feature applies to all groups, and 1 is the default group.
Set to 1 or an greater integer to set this feature only for
the corresponding group of loci.}

\item{variance}{Set to a value different from 0 to introduce variation in the
the parameter value for different loci. The
variation follows a gamma distribution with mean equal to
the value provided as \code{parameter}, and variance as given
here. Can also be set to a previously
created parameter, or an expression based on parameters.}
}
\value{
The demographic model with mutation.
}
\description{
This functions adds the assumption to the model that neutral mutations
occur in the genomes at a constant rate. The rate is quantified through
a parameter usually named theta in population genetics. It equals 4*N0*mu,
where N0 is the effective diploid population size of population one at the
time of sampling and mu is the neutral mutation rate for an entire locus.
}
\examples{
# Create a new parameter
dm <- dm.createDemographicModel(c(25,25), 100)
dm <- dm.addSpeciationEvent(dm, 0.01, 5)
dm <- dm.addMutation(dm, 1, 20)

# Create a new fixed parameter
dm <- dm.createDemographicModel(c(25,25), 100)
dm <- dm.addSpeciationEvent(dm, 0.01,5)
dm <- dm.addMutation(dm, fixed.value=7)

# Use an existing parameter
dm <- dm.createDemographicModel(c(25,25), 100)
dm <- dm.addParameter(dm, "theta", 0.01, 5)
dm <- dm.addMutation(dm, par.new=FALSE, parameter="2*log(theta)+1")
}

