% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaatha_model.R
\name{create_jaatha_model.function}
\alias{create_jaatha_model.function}
\title{Specify a jaatha model using a simulation function}
\usage{
\method{create_jaatha_model}{function}(x, par_ranges, sum_stats, ...,
  scaling_factor = 1, test = TRUE)
}
\arguments{
\item{x}{A simulation function. This function takes model parameters as 
input, and returns the simulated data. The function must take exactly one 
argument, which is a numeric vector of model parameters for which the 
simulation should be conducted. The function should return the simulation
results in an arbitrary format, that is then passed on to the summary
statistics.}

\item{par_ranges}{A matrix stating the possible values for the model 
parameters. The matrix must have one row for each parameter, and two
columns which state the minimal and maximal possible value for the 
parameter.}

\item{sum_stats}{A list of summary statistics created with 
\code{\link{create_jaatha_stat}}. The simulation results will be passed
to the statistics, which should convert them into a numeric vector.}

\item{...}{Currently unused.}

\item{scaling_factor}{If your model is a down-scaled version of your data,
you can indicated this using this value. The estimated expectation values
are multiplied with this factor before the likelihood is calculated.}

\item{test}{A logical indicating whether a simulation is performed to test
the model.}
}
\description{
This is the usual way to specify a jaatha model. An detailed exampled on 
doing so is given in the `jaatha-intro` vignette.
}
\examples{
create_jaatha_model(function(x) rpois(10, x),
                    par_ranges = matrix(c(0.1, 0.1, 10, 10), 2, 2),
                    sum_stats = list(create_jaatha_stat("sum", sum)))
}

