% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jack.R
\name{Jack}
\alias{Jack}
\title{Evaluation of Jack polynomials}
\usage{
Jack(x, lambda, alpha, algorithm = "DK")
}
\arguments{
\item{x}{numeric vector or \link[gmp]{bigq} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{alpha}{positive number or \code{bigq} rational number}

\item{algorithm}{the algorithm used, either \code{"DK"} (Demmel-Koev)
or \code{"naive"}}
}
\value{
A numeric scalar or a \code{bigq} rational number.
}
\description{
Evaluates a Jack polynomial.
}
\examples{
lambda <- c(2,1,1)
Jack(c(1/2, 2/3, 1), lambda, alpha = 3)
# exact value:
Jack(c(gmp::as.bigq(1,2), gmp::as.bigq(2,3), gmp::as.bigq(1)), lambda,
     alpha = gmp::as.bigq(3))
}
\references{
\itemize{
\item I.G. Macdonald.
\emph{Symmetric Functions and Hall Polynomials}.
Oxford Mathematical Monographs.
The Clarendon Press Oxford University Press,
New York, second edition, 1995.
\item J. Demmel & P. Koev.
\emph{Accurate and efficient evaluation of Schur and Jack functions}.
Mathematics of computations, vol. 75, n. 253, 223-229, 2005.
\item \emph{Jack polynomials}.
\url{https://www.math.upenn.edu/~peal/polynomials/jack.htm}
}
}
\seealso{
\code{\link{JackPol}}
}
