% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LittlewoodRichardson.R
\name{SkewSchurPol}
\alias{SkewSchurPol}
\title{Skew Schur polynomial}
\usage{
SkewSchurPol(n, lambda, mu)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}
}
\value{
A \code{qspray} multivariate polynomial, the skew Schur polynomial
  associated to the skew partition defined by \code{lambda} and \code{mu}.
}
\description{
Returns the skew Schur polynomial.
}
\details{
The computation is performed with the help of the
  Littlewood-Richardson rule (see \code{\link{LRskew}}).
}
\examples{
SkewSchurPol(3, lambda = c(3, 2, 1), mu = c(1, 1))
}
