% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hts_pacbio.R
\name{pacbio}
\alias{pacbio}
\title{Create and write PacBio reads to FASTQ file(s).}
\usage{
pacbio(seq_object, out_prefix, n_reads, chi2_params_s = c(0.01214, -5.12,
  675, 48303.0732881, 1.46910512123303), chi2_params_n = c(0.00189237136,
  2.5394497, 5500), max_passes = 40, sqrt_params = c(0.5, 0.2247),
  norm_params = c(0, 0.2), prob_thresh = 0.2, ins_prob = 0.11,
  del_prob = 0.04, sub_prob = 0.01, min_read_length = 50,
  lognorm_read_length = c(0.200110276521, -10075.4363813, 17922.611306),
  custom_read_lengths = NULL, prob_dup = 0, variant_probs = NULL,
  sep_files = FALSE, compress = FALSE, comp_method = "bgzip",
  n_threads = 1L, read_pool_size = 100L, show_progress = FALSE,
  overwrite = FALSE)
}
\arguments{
\item{seq_object}{Sequencing object of class \code{ref_genome} or \code{variants}.}

\item{out_prefix}{Prefix for the output file(s), including entire path except
for the file extension.}

\item{n_reads}{Number of reads you want to create.}

\item{chi2_params_s}{Vector containing the 5 parameters for the curve determining
the scale parameter for the chi^2 distribution.
Defaults to \code{c(0.01214, -5.12, 675, 48303.0732881, 1.4691051212330266)}.}

\item{chi2_params_n}{Vector containing the 3 parameters for the function
determining the n parameter for the chi^2 distribution.
Defaults to \code{c(0.00189237136, 2.53944970, 5500)}.}

\item{max_passes}{Maximal number of passes for one molecule.
Defaults to \code{40}.}

\item{sqrt_params}{Vector containing the 2 parameters for the square root
function for the quality increase.
Defaults to \code{c(0.5, 0.2247)}.}

\item{norm_params}{Vector containing the 2 parameters for normal distributed
noise added to quality increase square root function
Defaults to \code{c(0, 0.2)}.}

\item{prob_thresh}{Upper bound for the modified total error probability.
Defaults to \code{0.2}.}

\item{ins_prob}{Probability for insertions for reads with one pass.
Defaults to \code{0.11}.}

\item{del_prob}{Probability for deletions for reads with one pass.
Defaults to \code{0.04}.}

\item{sub_prob}{Probability for substitutions for reads with one pass.
Defaults to \code{0.01}.}

\item{min_read_length}{Minium read length for lognormal distribution.
Defaults to \code{50}.}

\item{lognorm_read_length}{Vector containing the 3 parameters for lognormal
read length distribution.
Defaults to \code{c(0.200110276521, -10075.4363813, 17922.611306)}.}

\item{custom_read_lengths}{Sample read lengths from a vector or column in a
matrix; if a matrix, the second column specifies the sampling weights.
If \code{NULL}, it samples read lengths from the lognormal distribution
using parameters in \code{lognorm_read_length}.
Defaults to \code{NULL}.}

\item{prob_dup}{A single number indicating the probability of duplicates.
Defaults to \code{0.0}.}

\item{variant_probs}{Relative probability of sampling each variant.
This is ignored if sequencing a reference genome.
\code{NULL} results in all having the same probability.
Defaults to \code{NULL}.}

\item{sep_files}{Logical indicating whether to make separate files for each variant.
This argument is coerced to \code{FALSE} if the \code{seq_object} argument is not
a \code{variants} object.
Defaults to \code{FALSE}.}

\item{compress}{Logical specifying whether or not to compress output file, or
an integer specifying the level of compression, from 1 to 9.
If \code{TRUE}, a compression level of \code{6} is used.
Defaults to \code{FALSE}.}

\item{comp_method}{Character specifying which type of compression to use if any
is desired. Options include \code{"gzip"} and \code{"bgzip"}.
This is ignored if \code{compress} is \code{FALSE}, and it throws an error if
it's set to \code{"gzip"} when \code{n_threads > 1} (since I don't have a method to
do gzip compression in parallel).
Defaults to \code{"bgzip"}.}

\item{n_threads}{The number of threads to use in processing.
If \code{compress} is \code{TRUE} or \code{> 0} (indicating compressed output),
setting \code{n_threads} to \code{2} or more makes this function first create an
uncompressed file/files using \code{n_threads} threads, then compress that/those
file/files also using \code{n_threads} threads.
There is no speed increase if you try to use multiple threads to create
compressed output on the fly, so that option is not included.
If you want to be conservative with disk space (by not having an uncompressed
file present even temporarily), set \code{n_threads} to \code{1}.
This argument is ignored if the package was not compiled with OpenMP.
Defaults to \code{1}.}

\item{read_pool_size}{The number of reads to store before writing to disk.
Increasing this number should improve speed but take up more memory.
Defaults to \code{100}.}

\item{show_progress}{Logical for whether to show a progress bar.
Defaults to \code{FALSE}.}

\item{overwrite}{Logical for whether to overwrite existing FASTQ file(s) of the
same name, if they exist.}
}
\value{
Nothing is returned.
}
\description{
From either a reference genome or set of haploid variants, create PacBio reads
and write them to FASTQ output file(s).
I encourage you to cite the reference below in addition to \code{jackalope} if you use
this function.
}
\section{ID lines}{

The ID lines for FASTQ files are formatted as such:

\code{@<genome name>-<sequence name>-<starting position>-<strand>}

where \code{genome name} is always \code{REF} for reference genomes (as opposed to variants).
}

\examples{
\donttest{
rg <- create_genome(10, 100e3, 100)
pacbio(rg, "pacbio_reads", n_reads = 100)
}

}
\references{
Stöcker, B. K., J. Köster, and S. Rahmann. 2016. SimLoRD: simulation of long
read data. \emph{Bioinformatics} \strong{32}:2704–2706.
}
