% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevo.R
\name{sub_models}
\alias{sub_models}
\alias{sub_JC69}
\alias{sub_K80}
\alias{sub_F81}
\alias{sub_HKY85}
\alias{sub_F84}
\alias{sub_TN93}
\alias{sub_GTR}
\alias{sub_UNREST}
\title{Construct necessary information for substitution models.}
\usage{
sub_JC69(lambda, gamma_shape = NULL, gamma_k = 5, invariant = 0)

sub_K80(alpha, beta, gamma_shape = NULL, gamma_k = 5, invariant = 0)

sub_F81(pi_tcag, gamma_shape = NULL, gamma_k = 5, invariant = 0)

sub_HKY85(pi_tcag, alpha, beta, gamma_shape = NULL, gamma_k = 5,
  invariant = 0)

sub_F84(pi_tcag, beta, kappa, gamma_shape = NULL, gamma_k = 5,
  invariant = 0)

sub_TN93(pi_tcag, alpha_1, alpha_2, beta, gamma_shape = NULL,
  gamma_k = 5, invariant = 0)

sub_GTR(pi_tcag, abcdef, gamma_shape = NULL, gamma_k = 5,
  invariant = 0)

sub_UNREST(Q, gamma_shape = NULL, gamma_k = 5, invariant = 0)
}
\arguments{
\item{lambda}{Substitution rate for all possible substitutions.}

\item{gamma_shape}{Numeric shape parameter for discrete Gamma distribution used for
among-site variability. Values must be greater than zero.
If this parameter is \code{NULL}, among-site variability is not included.
Defaults to \code{NULL}.}

\item{gamma_k}{The number of categories to split the discrete Gamma distribution
into. Values must be an integer in the range \code{[2,255]}.
This argument is ignored if \code{gamma_shape} is \code{NA}.
Defaults to \code{5}.}

\item{invariant}{Proportion of sites that are invariant.
Values must be in the range \code{[0,1)}.
Defaults to \code{0}.}

\item{alpha}{Substitution rate for transitions.}

\item{beta}{Substitution rate for transversions.}

\item{pi_tcag}{Vector of length 4 indicating the equilibrium distributions of
T, C, A, and G respectively. Values must be >= 0, and
they are forced to sum to 1.}

\item{kappa}{The transition/transversion rate ratio.}

\item{alpha_1}{Substitution rate for T <-> C transition.}

\item{alpha_2}{Substitution rate for A <-> G transition.}

\item{abcdef}{A vector of length 6 that contains the off-diagonal elements
for the substitution rate matrix.
See \code{vignette("sub-models")} for how the values are ordered in the matrix.}

\item{Q}{Matrix of substitution rates for "T", "C", "A", and "G", respectively.
Item \code{Q[i,j]} is the rate of substitution from nucleotide \code{i} to nucleotide \code{j}.
Do not include indel rates here!
Values on the diagonal are calculated inside the function so are ignored.}
}
\value{
A \code{sub_info} object, which is an R6 class that wraps the info needed for
the \code{create_variants} function.
It does not allow the user to directly manipulate the info inside, as that
should be done using the \code{sub_models} functions.
You can use the following methods from the class to view information:
\describe{
\item{\code{Q()}}{View a list of substitution rate matrices,
one for each Gamma category.}
\item{\code{pi_tcag()}}{View the equilibrium nucleotide frequencies.}
\item{\code{gammas()}}{View the discrete Gamma-class values.}
\item{\code{invariant()}}{View the proportion of invariant sites.}
\item{\code{model()}}{View the substitution model.}
\item{\code{U()}}{View list of the \code{U} matrices (one matrix per Gamma category)
used for calculating transition-probability matrices.
This is empty for UNREST models.}
\item{\code{Ui()}}{View list of the \code{U^-1} matrices (one matrix per Gamma category)
used for calculating transition-probability matrices.
This is empty for UNREST models.}
\item{\code{L()}}{View list of the lambda vectors (one vector per Gamma category)
used for calculating transition-probability matrices.
This is empty for UNREST models.}
}
}
\description{
For a more detailed explanation, see \code{vignette("sub-models")}.
}
\section{Functions}{
\itemize{
\item \code{sub_JC69}: JC69 model.

\item \code{sub_K80}: K80 model.

\item \code{sub_F81}: F81 model.

\item \code{sub_HKY85}: HKY85 model.

\item \code{sub_F84}: F84 model.

\item \code{sub_TN93}: TN93 model.

\item \code{sub_GTR}: GTR model.

\item \code{sub_UNREST}: UNREST model.
}}

\examples{
# Same substitution rate for all types:
obj_JC69 <- sub_JC69(lambda = 0.1)

# Transitions 2x more likely than transversions:
obj_K80 <- sub_K80(alpha = 0.2, beta = 0.1)

# Incorporating equilibrium frequencies:
obj_HKY85 <- sub_HKY85(pi_tcag = c(0.1, 0.2, 0.3, 0.4),
                       alpha = 0.2, beta = 0.1)

# 10-category Gamma distribution for among-site variability:
obj_K80 <- sub_K80(alpha = 0.2, beta = 0.1,
                   gamma_shape = 1, gamma_k = 10)

# Invariant sites:
obj_K80 <- sub_K80(alpha = 0.2, beta = 0.1,
                   invariant = 0.25)

}
\seealso{
\code{\link{create_variants}}
}
