% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{nbyname}
\alias{nbyname}
\title{Number of parameter nodes by parameter name}
\usage{
nbyname(x, justtotal = FALSE)
}
\arguments{
\item{x}{Output object from \code{jagsUI::jags()}}

\item{justtotal}{Whether to just report the total number of parameters, as opposed to dimensions.}
}
\value{
A \code{list} with an element associated with each parameter.  Each element
can be interpreted as the vector length or array dimension associated with the
given parameter.
}
\description{
Returns a list of the numbers of parameter nodes saved in \code{jagsUI} output, by parameter name.
As a default, what is returned for each list element is a vector of the array dimensions within the JAGS model
(that is, excluding the dimension associated with the number of MCMC samples for each parameter node),
or alternately, just the total number of parameter nodes.
}
\examples{
head(jags_df(asdf_jags_out))

nbyname(asdf_jags_out)

nparam(SS_out)
nbyname(SS_out)
}
\seealso{
\link{nparam}
}
\author{
Matt Tyers
}
