% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-lldf.R
\name{lldf}
\alias{lldf}
\title{Long listing of R session objects}
\usage{
lldf(
  n = Inf,
  envir = -1L,
  items = NULL,
  use_utils_objectsize = TRUE,
  all.names = TRUE,
  ...
)
}
\arguments{
\item{n}{\code{integer} or \code{Inf} indicating how many objects to
include in the output \code{data.frame}.}

\item{envir}{\code{environment} where the list of objects is obtained,
default \code{-1L} searches the environment of the caller, usually
the user workspace.
Other recognized options:
\itemize{
\item \code{character} string suitable for \code{as.environment()} which
recognizes the search path returned by \code{search()}
\item \code{integer} or \code{numeric} equivalent to environment relative position
as used in \code{ls()} argument \code{pos}.
}}

\item{items}{\code{character} of items to include, default NULL.}

\item{use_utils_objectsize}{\code{logical}, default TRUE, whether to prefer
\code{utils::object.size()}, otherwise it will attempt to use
\code{pryr::object_size()} if the package is installed.}

\item{all.names}{\code{logical} passed to \code{base::ls()} indicating whether
to include all names, where \code{all.names=TRUE} will include
hidden objects whose name begin with \code{"."} such as \code{".First"}.}

\item{...}{additional arguments are passed to \code{ls()}, notably
\code{pattern} can be passed to subset objects by regular expression.}
}
\value{
\code{data.frame} with summary of objects and object sizes,
sorted by decreasing object size.
}
\description{
Long listing of R session objects
}
\details{
This function expands \code{base::ls()} by also determining the
object size, and sorting to display the top \code{n} objects by
size, largest first.

This package will call \code{pryr::object_size} if available,
otherwise falls back to \code{utils::object.size()}.
}
\examples{
lldf(10);

# custom environment
newenv <- new.env();
newenv$A <- 1:10;
newenv$df <- data.frame(A=1:10, B=11:20);
lldf(envir=newenv);
rm(newenv);

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
