% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-mixedSort.R
\name{mixedOrder}
\alias{mixedOrder}
\title{order alphanumeric values keeping numeric values in proper order}
\usage{
mixedOrder(
  x,
  ...,
  blanksFirst = TRUE,
  na.last = NAlast,
  keepNegative = FALSE,
  keepInfinite = FALSE,
  keepDecimal = FALSE,
  ignore.case = TRUE,
  useCaseTiebreak = TRUE,
  honorFactor = FALSE,
  returnDebug = FALSE,
  returnType = c("order", "rank"),
  NAlast = TRUE,
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{x}{input vector}

\item{...}{additional parameters are sent to \code{mixedOrder()}.}

\item{blanksFirst}{\code{logical} whether to order blank entries before entries
containing a value.}

\item{na.last}{\code{logical} whether to move NA entries to the end of the sort.
When \code{na.last=TRUE} then \code{NA} values will always be last, even following
blanks and infinite values. When \code{na.last=FALSE} then \code{NA} values
will always be first, even before blanks and negative infinite values.}

\item{keepNegative}{\code{logical} whether to keep '-' associated with adjacent
numeric values, in order to sort them as negative values. Note that
\code{keepNegative=TRUE} also forces \code{keepDecimal=TRUE}, and enables
matching of scientific notation such as \code{-1.23e-10} as a numeric
value. When \code{keepNegative=FALSE} the dash \code{"-"} is treated as
a common delimiter.}

\item{keepInfinite}{\code{logical} whether to allow "Inf" in the input \code{x}
to be considered a numeric infinite value. Note that \code{"-Inf"} is
only treated as a negative infinite value when \code{keepNegative=TRUE}.
Also note that \code{"Inf"} is only recognized as infinite when it
appears between non-character delimiters, and not part of a
larger character string like \code{"Information"}. Be careful
with \code{keepInfinite=TRUE} when sorting gene symbols, there are
gene symbols like \code{"Inf3"} which should not be sorted as infinite.
Lastly, infinite values are sorted at the end, notably after
all character values which differs from some mixed sorting
algorithms.}

\item{keepDecimal}{\code{logical} whether to keep the decimal in numbers,
sorting as a true number and not as a version number. By default
\verb{keepDecimal=FALSE``, which means "v1.200" will be ordered after "v1.30", since it considers }"1.200"\verb{effectively as}1\code{and}200\verb{, and }"1.30"\verb{effectively as}1\code{and}30\verb{. When }keepDecimal=TRUE\verb{, the numeric sort orders }"v1.200"\code{before}"v1.30"`.}

\item{ignore.case}{\code{logical} whether to ignore uppercase and lowercase
characters when defining the sort order.}

\item{useCaseTiebreak}{\code{logical} indicating whether to break ties
when \code{ignore.case=TRUE}, using mixed case as a tiebreaker.}

\item{honorFactor}{\code{logical} indicating whether to honor the
order of \code{levels} if the input \code{x} is a \code{factor}. The default
\code{honorFactor=FALSE} is to maintain consistent legacy behavior.
The purpose of this function is to enable alphanumeric sorting,
which is not the purpose of sorting by factor levels.}

\item{returnDebug}{\code{logical} indicating whether to include
additional debug info as attributes.}

\item{returnType}{\code{character} string to define the return type:
\itemize{
\item "order": returns \code{integer} order, equivalent to \code{order()}
\item "rank": returns \code{integer} rank, equivalent to \code{rank()}
}}

\item{NAlast}{\code{logical} DEPRECATED in favor of \code{na.last} for
consistency with other base R functions.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{debug}{\code{logical} indicating whether to return intermediate data
useful only for debugging purposes.}
}
\value{
\code{integer} vector of orders derived from x,
or when \code{returnType="rank"} an integer vector of ranks allowing ties.
The rank is therefore valid for use in chains, such as multiple
columns of a \code{data.frame}.
}
\description{
order alphanumeric values keeping numeric values in proper order
}
\details{
This function is a refactor of \code{gtools} mixedorder() which was
the source of inspiration for this function, thanks to Gregory R. Warnes!
This function was designed to improve the efficiency for large vectors,
and to handle special cases slightly differently. It was driven by some
need to sort gene symbols, and miRNA symbols in numeric order, for example:

\describe{
\item{test set:}{miR-12,miR-1,miR-122,miR-1b,miR-1a,miR-2}
\item{\code{sort}:}{miR-1,miR-12,miR-122,miR-1a,miR-1b,miR-2}
\item{\code{gtools::mixedsort}:}{miR-122,miR-12,miR-2,miR-1,miR-1a,miR-1b}
\item{\code{mixedSort}:}{miR-1,miR-1a,miR-1b,miR-2,miR-12,miR-122}
}

This function does not by default consider negative numbers as negative,
instead it treats '-' as a delimiter, unless keepNegative=TRUE.

When \code{keepNegative=TRUE} this function also recognizes scientific
notation, for example \code{"1.23e-2"} will be treated as numeric \code{0.0123}.
Note that \code{keepNegative=TRUE} also forces \code{keepDecimal=TRUE}.

When \code{keepDecimal=TRUE} this function maintains numeric values that
include one \code{"."}.

This function is the core of a family of mixedSort functions:

\describe{
\item{\code{mixedSort()}}{Applies \code{mixedOrder()} to an input vector.}
\item{\code{mixedSorts()}}{Applies \code{mixedOrder()} to a list of vectors,
returning the list where each vector is independently sorted.}
\item{\code{mixedSortDF()}}{Applies \code{mixedOrder()} to each column of a
\code{data.frame} or comparable object, optionally specifying the order
of columns used during the sort.}
}

Extra thanks to Gregory R. Warnes for the \code{gtools} mixedorder()
that proved to be so useful it ultimately inspired this function.
}
\examples{
x <- c("miR-12","miR-1","miR-122","miR-1b", "miR-1a","miR-2");
mixedOrder(x);
x[mixedOrder(x)];
mixedSort(x);
order(x);
x[order(x)];
sort(x);

## Complex example including NA, blanks, and infinite "Inf"
x <- c("Inf",
   "+Inf12",
   NA,
   "-Inf14",
   "-",
   "---",
   "Jnf12",
   "Hnf12",
   "--",
   "Information");
## By default, strings are sorted as-is, "Hnf" before "Inf" before "Jnf"
## blanks are first, NA values are last
x[mixedOrder(x)];

## blanks are last, but before NA values which are also last
x[mixedOrder(x, blanksFirst=FALSE)];

## Recognize infinite, but not the negative sign
## Now infinite values are at the end, ordered by the number that follows.
x[mixedOrder(x, blanksFirst=FALSE, keepInfinite=TRUE)]

## Now also recognize negative infinite values,
## which puts "-Inf14" at the very beginning.
x[mixedOrder(x, blanksFirst=FALSE, keepInfinite=TRUE, keepNegative=TRUE)]

# test factor level order
factor1 <- factor(c("Cnot9", "Cnot8", "Cnot10"))
sort(factor1)
mixedSort(factor1)
factor1[mixedOrder(factor1)]
factor1[mixedOrder(factor1, honorFactor=TRUE)]

}
\seealso{
\code{gtools::mixedorder()}, \code{gtools::mixedsort()}

Other jam sort functions: 
\code{\link{mixedSort}()},
\code{\link{mixedSortDF}()},
\code{\link{mixedSorts}()},
\code{\link{mmixedOrder}()}
}
\concept{jam sort functions}
