% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{unalpha}
\alias{unalpha}
\title{Remove alpha transparency from colors}
\usage{
unalpha(x, keepNA = FALSE, ...)
}
\arguments{
\item{x}{\code{character} vector of R colors}

\item{keepNA}{\code{logical} indicating whether \code{NA} values should be kept
and therefore returned as \code{NA}.
When \code{keepNA=FALSE} (default for backward compatibility) \code{NA}
values are converted to \code{"#FFFFFF"} as done by \code{grDevices::col2rgb()}.}

\item{...}{additional arguments are ignored.}
}
\value{
character vector of R colors in hex format.
}
\description{
Remove alpha transparency from colors
}
\details{
This function simply removes the alpha transparency from
R colors, returned in hex format, for example \code{"#FF0000FF"}
becomes \code{"#FF0000"}, or \code{"blue"} becomes \code{"#0000FF"}.

It also silently converts R color names to hex format,
where applicable.
}
\examples{
unalpha(c("#FFFF00DD", "red", NA, "#0000FF", "transparent"))

unalpha(c("#FFFF00DD", "red", NA, "#0000FF", "transparent"), keepNA=TRUE)

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
