% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstab.R
\name{crosstab}
\alias{crosstab}
\alias{crosstab.default}
\alias{crosstab.data.frame}
\title{Generate a crosstabulation of two vectors.}
\usage{
crosstab(...)

\method{crosstab}{default}(vec1, vec2, percent = "none", show_na = TRUE,
  ...)

\method{crosstab}{data.frame}(.data, ...)
}
\arguments{
\item{...}{additional arguments, if calling \code{crosstab} on a data.frame.}

\item{vec1}{the vector to place on the crosstab column.  If supplying a data.frame, this should be an unquoted column name.}

\item{vec2}{the vector to place on the crosstab row.  If supplying a data.frame, this should be an unquoted column name.}

\item{percent}{which grouping to use for percentages, if desired (defaults to "none", which returns simple counts).  Must be one of "none", "row", "col", or "all".}

\item{show_na}{a logical value indicating whether counts should be displayed where either variable is \code{NA}.}

\item{.data}{(optional) a data.frame, in which case \code{vec1} and \code{vec2} should be unquoted column names.}
}
\value{
Returns a data.frame with the frequencies of the crosstabulated variables.
}
\description{
Create a crosstab, displaying either frequencies or percentages calculated by row, column, or overall.

\code{crosstab} can be called in two ways:

1) It can simply be called on two vectors, like \code{crosstab(mtcars$gear, mtcars$cyl)}.

2) Or, when both vectors are columns in a single data.frame, the data.frame can be provided as the first argument, followed by two unquoted column names to crosstabulate.  This enables passing in a data.frame from a \code{\%>\%} pipeline, in addition to making for a shorter function call.  Like \code{mtcars \%>\% crosstab(gear, cyl)}. 

For fancy formatting of the resulting data.frame, see \code{\link{adorn_crosstab}}.
}
\examples{
# Calling on two vectors:
a <- c("hi", "hi", "lo", "lo")
b <- c(1, 2, 2, 2)
crosstab(a, b)

crosstab(mtcars$cyl, mtcars$gear)
crosstab(mtcars$cyl, mtcars$gear, "row")

# Passing in a data.frame using a pipeline:
mtcars \%>\% crosstab(cyl, gear)
mtcars \%>\% crosstab(cyl, gear, "row")

# This allows for upstream operations
# prior to the crosstab() call:
library(dplyr)
mtcars \%>\%
  filter(am == 0) \%>\%
  crosstab(cyl, gear)
}
