% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabyl.R
\name{tabyl}
\alias{tabyl}
\alias{tabyl.default}
\alias{tabyl.data.frame}
\title{Generate a frequency table from a vector.}
\usage{
tabyl(...)

\method{tabyl}{default}(vec, sort = FALSE, show_na = TRUE, ...)

\method{tabyl}{data.frame}(.data, ...)
}
\arguments{
\item{...}{additional arguments, if calling \code{tabyl} on a data.frame.}

\item{vec}{the vector to tabulate.  If supplying a data.frame, this should be an unquoted column name.}

\item{sort}{a logical value indicating whether the resulting table should be sorted in descending order of \code{n}.}

\item{show_na}{a logical value indicating whether the count of \code{NA} values should be displayed, along with an additional column showing valid percentages.}

\item{.data}{(optional) a data.frame, in which case \code{vec} should be an unquoted column name.}
}
\value{
Returns a data.frame with the frequencies and percentages of the tabulated variable.
}
\description{
Create a frequency table of a variable, returned as a data.frame.  It shows counts, percentages and, if \code{NA} values are present, valid percentages (calculated excluding \code{NA} values).  A fully-featured alternative to \code{table()}.

\code{tabyl} can be called in two ways:

1) It can simply be called on a vector, like \code{tabyl(mtcars$gear)}.

2) A data.frame can be provided as the first argument, followed by an unquoted column name to tabulate.  This enables passing in a data.frame from a \code{\%>\%} pipeline, like \code{mtcars \%>\% tabyl(gear)}.
}
\examples{
# Calling on a vector:
val <- c("hi", "med", "med", "lo")
tabyl(val)
tabyl(mtcars$cyl, sort = TRUE)

# Passing in a data.frame using a pipeline:
mtcars \%>\% tabyl(cyl, sort = TRUE)

# illustrating show_na functionality:
my_cars <- rbind(mtcars, rep(NA, 11))
tabyl(my_cars$cyl)
tabyl(my_cars$cyl, show_na = FALSE)
}
