% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaod_journal.R
\name{jaod_journal}
\alias{jaod_journal}
\title{Get a journal by ID}
\usage{
jaod_journal(id, ...)
}
\arguments{
\item{id}{(character) a DOAJ journal ID, a UUID. Note, this
is not an ISSN, but you can use \code{\link[=jaod_journal_search]{jaod_journal_search()}} to
search by ISSN to get the DOAJ id}

\item{...}{curl options passed on to \code{\link[crul]{verb-GET}},
see \code{?curl::curl_options} for help on curl options}
}
\value{
a named list, with slots admin, last_updated, id, created_date,
and bibjson
}
\description{
Get a journal by ID
}
\examples{
\dontrun{
out <- jaod_journal(id = "f3f2e7f23d444370ae5f5199f85bc100")
out$admin
out$last_updated
out$id
out$created_date
out$bibjson

ids <- c("f3f2e7f23d444370ae5f5199f85bc100",
"9abfb36b06404e8a8566e1a44180bbdc")
out <- lapply(ids, jaod_journal)
out[[1]]
}
}
