% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contin_jcolors.R
\name{jcolors_contin}
\alias{jcolors_contin}
\title{continuous palettes of colors for figures}
\usage{
jcolors_contin(palette = c("default", "pal2", "pal3", "pal4", "pal10",
  "pal11", "pal12", "rainbow"), reverse = FALSE, interpolate = c("spline",
  "linear"), ...)
}
\arguments{
\item{palette}{Character string indicating a palette of colors.}

\item{reverse}{logical value indicating whether the color palette should be reversed. Defaults
to \code{FALSE}}

\item{interpolate}{Character string for color interpolation method.
"linear" or "spline" interpolation available}

\item{...}{other arguments to be passed to \code{\link[grDevices]{colorRampPalette}}.
See \code{\link[grDevices]{colorRampPalette}} for details}
}
\value{
returns a function that takes an integer argument (the required number of colors), which
then returns a character vector of colors
}
\description{
Creates different color palette functions
}
\examples{

colfunc <- jcolors_contin()
jcols   <- colfunc(1000)
n       <- length(jcols)
image(1:n, 1, as.matrix(1:n),
      col  = jcols,
      xlab = "", ylab = "",
      xaxt = "n", yaxt = "n", bty = "n")

}
