% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jlmer_spec.R
\name{make_jlmer_spec}
\alias{make_jlmer_spec}
\title{Create a specifications object for fitting regression models in Julia}
\usage{
make_jlmer_spec(
  formula,
  data,
  subject = NULL,
  trial = NULL,
  time = NULL,
  drop_terms = NULL,
  ...
)
}
\arguments{
\item{formula}{Model formula in R syntax}

\item{data}{A data frame}

\item{subject}{Column for subjects in the data.}

\item{trial}{Column for trials in the data. Must uniquely identify a time series within subject
(for example, the column for items in a counterbalanced design where each subject sees exactly one item).}

\item{time}{Column for time in the data.}

\item{drop_terms}{(Optional) any terms to drop from the reconstructed model formula}

\item{...}{Unused, for extensibility.}
}
\value{
An object of class \code{jlmer_spec}.
}
\description{
Create a specifications object for fitting regression models in Julia
}
\examples{
# Bare specification object (minimal spec for fitting a global model)
spec <- make_jlmer_spec(weight ~ 1 + Diet, ChickWeight)
spec

# Constraints on specification for CPA:
# 1) The combination of `subject`, `trial`, and `time` must uniquely identify rows in the data
# 2) `time` must have constant sampling rate (i.e., evenly spaced values)
spec_wrong <- make_jlmer_spec(
  weight ~ 1 + Diet, ChickWeight,
  time = "Time"
)
unique(ChickWeight$Time)

# Corrected specification for the above
spec_correct <- make_jlmer_spec(
  weight ~ 1 + Diet, subset(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec_correct

}
