% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJColByName}
\alias{GetJColByName}
\title{GetJColByName}
\usage{
GetJColByName(fname, colname)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}

\item{colname}{The name of the column to be returned. If the matrix has no column names, or the name is not found, an empty vector is returned}
}
\value{
A numeric vector with the values of elements in the requested column
}
\description{
Returns (as a R numeric vector) the requested named column from the matrix contained in a jmatrix binary file
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
Rf[,"c"]
vf<-GetJColByName("Rfullfloat.bin","c")
vf
file.remove("Rfullfloat.bin")
}
