% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestones.h.R
\name{ttestOneS}
\alias{ttestOneS}
\title{One Sample T-Test}
\usage{
ttestOneS(data, vars, students = TRUE, bf = FALSE, bfPrior = 0.707,
  mann = FALSE, testValue = 0, hypothesis = "dt", norm = FALSE,
  meanDiff = FALSE, effectSize = FALSE, ci = FALSE, ciWidth = 95,
  desc = FALSE, plots = FALSE, miss = "perAnalysis")
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in
\code{data}}

\item{students}{\code{TRUE} (default) or \code{FALSE}, perform Student's
t-tests}

\item{bf}{\code{TRUE} or \code{FALSE} (default), provide Bayes factors}

\item{bfPrior}{a number between 0.5 and 2 (default 0.707), the prior width
to use in calculating Bayes factors}

\item{mann}{\code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U
test}

\item{testValue}{a number specifying the value of the null hypothesis}

\item{hypothesis}{\code{'dt'} (default), \code{'gt'} or \code{'lt'}, the
alternative hypothesis; different to \code{testValue}, greater than
\code{testValue}, and less than \code{testValue} respectively}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-wilk
tests of normality}

\item{meanDiff}{\code{TRUE} or \code{FALSE} (default), provide means and
standard deviations}

\item{effectSize}{\code{TRUE} or \code{FALSE} (default), provide effect
sizes}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide descriptive
plots}

\item{miss}{\code{'perAnalysis'} or \code{'listwise'}, how to handle
missing values; \code{'perAnalysis'} excludes missing values for individual
dependent variables, \code{'listwise'} excludes a row from all analyses if
one of its entries is missing.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
  \code{results$normality} \tab \tab \tab \tab \tab a table containing the normality test results \cr
  \code{results$descriptives} \tab \tab \tab \tab \tab a table containing the descriptives \cr
  \code{results$plots} \tab \tab \tab \tab \tab an image of the descriptive plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$ttest$asDF}

\code{as.data.frame(results$ttest)}
}
\description{
One Sample T-Test
}
\examples{
data('ToothGrowth')

ttestOneS(ToothGrowth, vars = c('len', 'dose'))

#
#  One Sample T-Test
#
#  One Sample T-Test
#  ------------------------------------------------------
#                           statistic    df      p
#  ------------------------------------------------------
#    len     Student's t         19.1    59.0    < .001
#    dose    Student's t         14.4    59.0    < .001
#  ------------------------------------------------------
#

}
