% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovanp.h.R
\name{anovaNP}
\alias{anovaNP}
\title{One-Way ANOVA (Non-parametric)}
\usage{
anovaNP(data, deps, group, es = FALSE, pairs = FALSE, formula)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a string naming the dependent variable in \code{data}}

\item{group}{a string naming the grouping or independent variable in
\code{data}}

\item{es}{\code{TRUE} or \code{FALSE} (default), provide effect-sizes}

\item{pairs}{\code{TRUE} or \code{FALSE} (default), perform pairwise
comparisons}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$table} \tab \tab \tab \tab \tab a table of the test results \cr
  \code{results$comparisons} \tab \tab \tab \tab \tab an array of pairwise comparison tables \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$table$asDF}

\code{as.data.frame(results$table)}
}
\description{
The Kruskal-Wallis test is used to explore the relationship between a 
continuous dependent variable, and a categorical explanatory variable. It 
is analagous to ANOVA, but with the advantage of being non-parametric and 
having fewer assumptions. However, it has the limitation that it can only 
test a single explanatory variable at a time.
}
\examples{
data('ToothGrowth')

anovaNP(formula = len ~ dose, data=ToothGrowth)

#
#  ONE-WAY ANOVA (NON-PARAMETRIC)
#
#  Kruskal-Wallis
#  -------------------------------
#           X²      df    p
#  -------------------------------
#    len    40.7     2    < .001
#  -------------------------------
#

}
