% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{filter_table}
\alias{filter_table}
\title{Apply query to a dataframe}
\usage{
filter_table(data = NULL, filters = NULL)
}
\arguments{
\item{data}{\code{data.frame} to filter.}

\item{filters}{output from queryBuilder when \code{return_value = "r_rules"}.}
}
\value{
A filtered version of the input \code{data.frame}
}
\description{
Filter a dataframe using the output of a queryBuilder. The \code{return_value}
Should be set to \code{r_rules}, and the list of filters should contain column names
that are present in the data as their id value.
}
\examples{

library(shiny)
library(jqbr)

filters <- list(
  list(
    id = "cyl",
    type = "integer",
    input = "radio",
    values = list(
      4,
      6,
      8
    )
  )
)

ui <- fluidPage(
  queryBuilderInput(
    inputId = "r_filter",
    filters = filters,
    return_value = "r_rules"
  ),
  tableOutput("cars")
)

server <- function(input, output) {
  output$cars <- renderTable({
    filter_table(mtcars, input$r_filter)
  })
}


if (interactive()) {
  shinyApp(ui, server)
}
}
