% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uglify.R
\name{uglify}
\alias{uglify}
\alias{uglify_reformat}
\alias{uglify_optimize}
\alias{uglify_files}
\title{Compress and Reformat JavaScript Code}
\usage{
uglify_reformat(text, beautify = FALSE, ...)

uglify_optimize(text, ...)

uglify_files(files, ...)
}
\arguments{
\item{text}{a character vector with JavaScript code}

\item{beautify}{prettify (instead of minify) code}

\item{files}{a character vector of filenames}

\item{...}{additional arguments for the \href{http://lisperator.net/uglifyjs/compress}{optimizer}
or \href{http://lisperator.net/uglifyjs/codegen}{generator}.}
}
\description{
\href{https://www.npmjs.com/package/uglify-js}{UglifyJS} is a JavaScript
compressor/minifier written in JavaScript. It also contains tools that allow one
to automate working with JavaScript code.
}
\examples{
code <- "function test(x, y){ x = x || 1; y = y || 1; return x*y;}"
cat(uglify_optimize(code))
cat(uglify_reformat(code, beautify = TRUE, indent_level = 2))
}
\references{
UglifyJS2 Documentation: \url{http://lisperator.net/uglifyjs/}.
}
