% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{jsonld}
\alias{jsonld}
\alias{jsonld_compact}
\alias{jsonld_expand}
\alias{jsonld_flatten}
\alias{jsonld_frame}
\alias{jsonld_from_rdf}
\alias{jsonld_to_rdf}
\alias{jsonld_normalize}
\title{Working with JSON-LD}
\usage{
jsonld_compact(doc, context)

jsonld_expand(compacted)

jsonld_flatten(doc)

jsonld_frame(doc)

jsonld_from_rdf(rdf, format = "application/nquads")

jsonld_to_rdf(doc, format = "application/nquads")

jsonld_normalize(doc, algorithm = "URDNA2015",
  format = "application/nquads")
}
\arguments{
\item{doc}{string with JSON-LD document}

\item{context}{string with JSON-LD context}

\item{compacted}{string with JSON message}

\item{rdf}{string with RDF text}

\item{format}{a MIME type}

\item{algorithm}{normalization algorithm}
}
\description{
Wrappers for converting, expanding and compacting JSON-LD documents. All parameters
and return values must be JSON strings. Use \link[jsonlite:toJSON]{jsonlite::toJSON} and \link[jsonlite:fromJSON]{jsonlite::fromJSON}
to convert between R objects and JSON format. The \href{https://github.com/ropensci/jsonld#readme}{readme}
has basic examples.
}
\examples{
# Example from https://github.com/digitalbazaar/jsonld.js#quick-examples
doc <- '{
  "http://schema.org/name": "Manu Sporny",
  "http://schema.org/url": {"@id": "http://manu.sporny.org/"},
  "http://schema.org/image": {"@id": "http://manu.sporny.org/images/manu.png"}
}'

context <- '{
  "name": "http://schema.org/name",
  "homepage": {"@id": "http://schema.org/url", "@type": "@id"},
  "image": {"@id": "http://schema.org/image", "@type": "@id"}
}'

# Compact and expand:
(out <- jsonld_compact(doc, context))
(expanded <- jsonld_expand(out))

# Convert between JSON and RDF:
cat(nquads <- jsonld_to_rdf(doc))
jsonld_from_rdf(nquads)

# Other utilities:
jsonld_flatten(doc)
cat(jsonld_normalize(doc))
}

