% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_unnest_wider.R
\name{json_unnest_wider}
\alias{json_unnest_wider}
\title{Unnest a JSON object into columns}
\usage{
json_unnest_wider(
  data,
  col,
  ptype = list(),
  names_sort = FALSE,
  names_sep = NULL,
  names_repair = "check_unique",
  wrap_scalars = FALSE,
  bigint_as_char = bigint_default()
)
}
\arguments{
\item{data}{A data frame.}

\item{col}{JSON-column of arrays to extract components from.}

\item{ptype}{Output type. If \code{NULL}, the default, the output type is
determined by computing the common type across all elements. Use
\code{new_json_array()} resp. \code{new_json_object()} if you know every element is
an array resp. object. Mind that the return type will only be \code{json2}.}

\item{names_sort}{Should the extracted columns be sorted by name? If \code{FALSE},
the default, the columns are sorted by appearance.}

\item{names_sep}{If \code{NULL}, the default, the keys of the objects in \code{col}
are used as the column names. If a character it is used to join \code{col} and
the object keys.}

\item{names_repair}{What happens if the output has invalid column names?}

\item{wrap_scalars}{A named list of \code{TRUE} or \code{FALSE} specifying for each
field whether to wrap scalar values in a JSON array. Unspecified fields
are not wrapped. This can also be a single value of \code{TRUE} or \code{FALSE}
that is then used for every field.
Note that scalars are only wrapped if either
\itemize{
\item \code{ptype} is \code{new_json_array()} or \code{json2} vector.
\item \code{ptype} is \code{NULL} and the elements are a mix of scalar values and arrays.
}}

\item{bigint_as_char}{Convert big integers to character? The option
\code{jsontools.bigint_as_char} is used as default.}
}
\value{
A data frame, or subclass of data frame of the same length as \code{data}.
}
\description{
Unnest a column of JSON objects in a data frame producing a wider data frame.
}
\examples{
# turn all components of item into columns with json_unnest_wider()
tibble::tibble(
  id = 1:2,
  x = c(
    '{"name": "Peter", "age": 19}',
    '{"age": 37}'
  )
) \%>\%
  json_unnest_wider(x)

# sort names and specify proto types
tibble::tibble(
  id = 1:2,
  x = c(
    '{"name": "Peter", "age": 19, "purchase_ids": [1, 2]}',
    '{"age": 37, "purchase_ids": []}'
  )
) \%>\%
  json_unnest_wider(
    x,
    ptype = list(
      age = integer(),
      name = character(),
      purchase_id = new_json_array()
    ),
    names_sort = TRUE
  )
}
\seealso{
\code{\link[=json_unnest_longer]{json_unnest_longer()}}
}
