% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_plot.R
\name{cat_plot}
\alias{cat_plot}
\title{Plot interaction effects between categorical predictors.}
\usage{
cat_plot(model, pred, modx = NULL, mod2 = NULL, geom = c("dot", "line",
  "bar", "boxplot"), interval = TRUE, plot.points = FALSE,
  point.shape = FALSE, vary.lty = FALSE, centered = NULL,
  int.type = c("confidence", "prediction"), int.width = 0.95,
  outcome.scale = "response", set.offset = 1, x.label = NULL,
  y.label = NULL, main.title = NULL, legend.main = NULL,
  color.class = "Set2")
}
\arguments{
\item{model}{A regression model of type \code{lm}, \code{glm},
\code{\link[survey]{svyglm}}, or \code{\link[lme4]{merMod}}. It should
contain the interaction of interest. Models from other classes may work as
well but are not officially supported.}

\item{pred}{A categorical predictor variable that will appear on the x-axis.}

\item{modx}{A categorical moderator variable.}

\item{mod2}{For three-way interactions, the second categorical moderator.}

\item{geom}{What type of plot should this be? There are several options
here since the best way to visualize categorical interactions varies by
context. Here are the options:
\itemize{
\item \code{"dot"}: The default. Simply plot the point estimates. You may want to
use
\code{point.shape = TRUE} with this and you should also consider
\code{interval = TRUE} to visualize uncertainty.
\item \code{"line"}: This connects observations across levels of the \code{pred}
variable with a line. This is a good option when the \code{pred} variable
is ordinal (ordered). You may still consider \code{point.shape = TRUE} and
\code{interval = TRUE} is still a good idea.
\item \code{"bar"}: A bar chart. Some call this a "dynamite plot."
Many applied researchers advise against this type of plot because it
does not represent the distribution of the observed data or the
uncertainty of the predictions very well. It is best to at least use the
\code{interval = TRUE} argument with this geom.
\item \code{"boxplot"}: This geom plots a dot and whisker plot. These can be useful
for understanding the distribution of the observed data without having
to plot all the observed points (especially helpful with larger data
sets). \strong{However}, it is important to note the boxplots are not based
on the model whatsoever.
}}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction
intervals. Not supported for \code{merMod} models.}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as a
scatterplot on top of the interaction lines. Note that if
\code{geom = "bar"}, this will cause the bars to become transparent so you can
see the points.}

\item{point.shape}{For plotted points---either of observed data or predicted
values with the "point" or "line" geoms---should the shape of the points
vary by the values of the factor? This is especially useful if you aim to
be black and white printing- or colorblind-friendly.}

\item{vary.lty}{Should the resulting plot have different shapes for each
line in addition to colors? Defaults to \code{TRUE}.}

\item{centered}{A vector of quoted variable names that are to be
mean-centered. If \code{NULL}, all non-focal predictors are centered. If
not \code{NULL}, only the user-specified predictors are centered. User can
also use "none" or "all" arguments. The response variable is not centered
unless specified directly.}

\item{int.type}{Type of interval to plot. Options are "confidence" or
"prediction". Default is confidence interval.}

\item{int.width}{How large should the interval be, relative to the standard
error? The default, .95, corresponds to roughly 1.96 standard errors and
a .05 alpha level for values outside the range. In other words, for a
confidence interval, .95 is analogous to a 95\% confidence interval.}

\item{outcome.scale}{For nonlinear models (i.e., GLMs), should the outcome
variable be plotted on the link scale (e.g., log odds for logit models) or
the original scale (e.g., predicted probabilities for logit models)? The
default is \code{"response"}, which is the original scale. For the link
scale, which will show straight lines rather than curves, use
\code{"link"}.}

\item{set.offset}{For models with an offset (e.g., Poisson models), sets a
offset for the predicted values. All predicted values will have the same
offset. By default, this is set to 1, which makes the predicted values a
proportion. See details for more about offset support.}

\item{x.label}{A character object specifying the desired x-axis label. If
\code{NULL}, the variable name is used.}

\item{y.label}{A character object specifying the desired x-axis label. If
\code{NULL}, the variable name is used.}

\item{main.title}{A character object that will be used as an overall title
for the plot. If \code{NULL}, no main title is used.}

\item{legend.main}{A character object that will be used as the title that
appears above the legend. If \code{NULL}, the name of the moderating
variable is used.}

\item{color.class}{Any palette argument accepted by
\code{\link[ggplot2]{scale_colour_brewer}}. Default is "Set2" for factor
moderators. You may also simply supply a vector of colors accepted by
\code{ggplot2} and of equal length to the number of moderator levels.}
}
\value{
The functions returns a \code{ggplot} object, which can be treated
like a user-created plot and expanded upon as such.
}
\description{
\code{cat_plot} is a complementary function to \code{\link[=interact_plot]{interact_plot()}} that is designed
for plotting interactions when both predictor and moderator(s) are
categorical (or, in R terms, factors).
}
\details{
This function provides a means for plotting conditional effects
for the purpose of exploring interactions in the context of regression.
You must have the
package \code{ggplot2} installed to benefit from these plotting functions.

The function is designed for two and three-way interactions. For
additional terms, the
\code{\link[effects]{effects}} package may be better suited to the task.

This function supports nonlinear and generalized linear models and by
default will plot them on
their original scale (\code{outcome.scale = "response"}).

While mixed effects models from \code{lme4} are supported, only the fixed
effects are plotted. \code{lme4} does not provide confidence intervals,
so they are not supported with this function either.

Note: to use transformed predictors, e.g., \code{log(variable)},
put its name in quotes or backticks in the argument.

\emph{Info about offsets:}

Offsets are partially supported by this function with important
limitations. First of all, only a single offset per model is supported.
Second, it is best in general to specify offsets with the offset argument
of the model fitting function rather than in the formula. If it is
specified in the formula with a svyglm, this function will stop with an
error message.

It is also advised not to do any transformations to the offset other than
the common log transformation. If you apply a log transform, this function
will deal with it sensibly. So if your offset is a logged count, the
exposure you set will be the non-logged version, which is much easeir to
wrap one's head around. For any other transformation you may apply, or
if you apply no transformation at all, the exposures used will be the
post-tranformation number (which is by default 1).
}
\examples{

library(ggplot2)
fit <- lm(price ~ cut * color, data = diamonds)
cat_plot(fit, pred = color, modx = cut, interval = TRUE)

# 3-way interaction

## Will first create a couple dichotomous factors to ensure full rank
mpg2 <- mpg
mpg2$auto <- "auto"
mpg2$auto[mpg2$trans \%in\% c("manual(m5)", "manual(m6)")] <- "manual"
mpg2$fwd <- "2wd"
mpg2$fwd[mpg2$drv == "4"] <- "4wd"
## Drop the two cars with 5 cylinders (rest are 4, 6, or 8)
mpg2 <- mpg2[mpg2$cyl != "5",]
## Fit the model
fit3 <- lm(cty ~ cyl * fwd * auto, data = mpg2)

# The line geom looks good for an ordered factor predictor
cat_plot(fit3, pred = cyl, modx = fwd, mod2 = auto, geom = "line",
 interval = TRUE)

}
\seealso{
Other interaction tools: \code{\link{interact_plot}},
  \code{\link{johnson_neyman}},
  \code{\link{probe_interaction}}, \code{\link{sim_slopes}}
}
\concept{interaction tools}
