% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fit_functions.R, R/qtls.R
\name{fit_sb}
\alias{fit_sb}
\alias{fit_sl}
\alias{fit_su}
\alias{qtls}
\title{Fit Functions for Johnson Curves}
\usage{
fit_sb(x, q)

fit_su(x, q)

fit_sl(x, q)

qtls(x, z)
}
\arguments{
\item{x}{the non-normal numerical data.}

\item{q}{the quantiles and some statistics generated by quantiles, it must be
the return value of \code{qtls} function.}

\item{z}{a single z value for model fitting. It's returned by
  \code{\link{jtrans}}}
}
\value{
return NA when the prediction failed, return a list with 2 component
  when fit succeeded. The first component \code{trans} is the transformed
  value and the second component \code{params} is the parameters used in the
  transformation.
}
\description{
Fit functions for three Johnson Curves.
}
\details{
Three types of transformations are SB, SL and SU. Their forms are described
below: \deqn{S_B:   Z = \gamma + \eta * ln((X-\epsilon) / (\lambda + \epsilon
- X))} \deqn{S_L:   Z = \gamma + \eta * ln(X - \epsilon)} \deqn{S_U:   Z =
\gamma + \eta * asinh((X-\epsilon) / \lambda)} in whihc Z is the standard
normal varible, and X is the non-normal original data, all the necessary
parameters will be returned. Before fitting these curves, sample quantiles
should be calculated according to z values. the \code{qtls} function here is
to provide every useful parameters for Johnson curve fitting.

These functions could also be used for predicting new values when you have
already fitted a model and obtained a \code{jtrans} object. This could be
done by set the \code{newx} parameter. See examples for details.

Note that when predicting new data, the new data should be from the same
distribution as the original data used for fitting the model. All fits have
certain restrictions on data range, if the new data is outside the range of
the model, the prediction will return NA for all the values. Try to exclude
some out-of-range values and predict again may fix this problem.
}

