% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kable_as_image.R
\name{kable_as_image}
\alias{kable_as_image}
\title{Convert a LaTeX table to an image and place it in a rmarkdown document}
\usage{
kable_as_image(kable_input, filename = NULL, file_format = "png",
  latex_header_includes = NULL, keep_pdf = FALSE)
}
\arguments{
\item{kable_input}{Raw LaTeX code to generate a table. It doesn't have to
came from \code{kable} or \code{kableExtra}.}

\item{filename}{Character String. If specified, the image will be saved under
the specified (path &) name. You don't need to put file format like ".png"
here.}

\item{file_format}{Character String to specify image format, such as \code{png},
\code{jpeg}, \code{gif}, \code{tiff}, etc. Default is \code{png}.}

\item{latex_header_includes}{A character vector of extra LaTeX header stuff.
Each element is a row. You can have things like
\code{c("\\usepackage{threeparttable}", "\\usepackage{icons}")}}

\item{keep_pdf}{A T/F option to control if the mid-way standalone pdf should
be kept. Default is \code{FALSE}.}
}
\description{
This is a LaTeX-only function. This function will render the
raw LaTeX code (could be codes generated by other table packages like
\code{xtable}) to generate a table, convert it to an image and put it back to a
rmarkdown environment. It is a "better than nothing" solution to print high
quality tables in rmarkdown Word document. By using this, you need to take
the responsibility of explaining to your collaborators why they can't make
edits to the tables in Word.

Also, if a filename is provided, user has the option to "save" the table to
an image file like \code{ggplot2::ggsave()}.

The idea of this function was coming from \href{https://stackoverflow.com/questions/44711313/save-rmarkdowns-report-tables-and-figures-to-file}{this StackOverflow question}.
The approach was learned and adopted from the \href{https://github.com/metrumresearchgroup/texPreview}{texpreview}
package, which allows you to preview the results of TeX code in the Viewer panel.
}
