% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_rows.R
\name{collapse_rows}
\alias{collapse_rows}
\title{Collapse repeated rows to multirow cell}
\usage{
collapse_rows(kable_input, columns = NULL)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{columns}{Numeric column positions where rows need to be collapsed.}
}
\description{
Collapse same values in columns into multirow cells. This
feature does similar things with \code{group_rows}. However, unlike \code{group_rows},
it analyzes existing columns, finds out rows that can be grouped together,
and make them multirow cells. Note that if you want to use \code{column_spec} to
specify column styles, you should use \code{column_spec} before \code{collapse_rows}.
}
\examples{
dt <- data.frame(a = c(1, 1, 2, 2), b = c("a", "a", "a", "b"))
x <- knitr::kable(dt, "html")
collapse_rows(x)

}
