% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scroll_box.R
\name{scroll_box}
\alias{scroll_box}
\title{Put a HTML table into a scrollable box}
\usage{
scroll_box(kable_input, height = NULL, width = NULL,
  box_css = "border: 1px solid #ddd; padding: 5px; ", extra_css = NULL)
}
\arguments{
\item{kable_input}{A HTML kable object}

\item{height}{A character string indicating the height of the box, e.g. "50px"}

\item{width}{A character string indicating the width of the box, e.g. "100px"}

\item{box_css}{CSS text for the box}

\item{extra_css}{Extra CSS styles}
}
\description{
This function will put a HTML kable object in a fixed-height,
fixed-width or both box and make it scrollable.
}
\examples{
\dontrun{
# Specify table size by pixels
kable(cbind(mtcars, mtcars), "html") \%>\%
    kable_styling() \%>\%
    scroll_box(width = "500px", height = "200px")

# Specify by percent
kable(cbind(mtcars, mtcars), "html") \%>\%
    kable_styling() \%>\%
    scroll_box(width = "100\%", height = "200px")
}
}
