% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjivec.R
\name{plot.kanjivec}
\alias{plot.kanjivec}
\title{Plot kanjivec objects}
\usage{
\method{plot}{kanjivec}(
  x,
  type = c("kanji", "dend"),
  seg_depth = 0,
  palette = "Dark 3",
  pal.extra = 0,
  numbers = FALSE,
  offset = c(0.025, 0),
  family = NULL,
  lwd = 8,
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{kanjivec}}}

\item{type}{either "kanji" or "dend". Whether to plot the actual kanji, coloring strokes
according to levels of segmentation, or to plot a representation of the tree structure
underlying this segmentation. Among the following named parameters, only \code{family} is
for use with \code{type = "dend"}; all others are for \code{type = "dend"}.}

\item{seg_depth}{an integer. How many steps down the segmentation hierarchy we use
different colors for different groups. If zero (the default), only one color is used
that can be specified with \code{col} passed via \code{...} as usual}

\item{palette}{a valid name of a hcl palette (one of \code{hcl.pals()}). Used for coloring the
components if \code{seg_depth} is \eqn{>0}.}

\item{pal.extra}{an integer. How many extra colors are picked in the specified palette.
If this is 0 (the default), palette is used with as many colors as we have components.
Since many hcl palettes run from dark to light colors, the last (few) components may
be too light. Increasing pal.extra then makes the component colors somewhat more similar,
but the last component darker.}

\item{numbers}{logical. Shall the stroke numbers be displayed.}

\item{offset}{the (x,y)-offset for the numbers relative to the positions from kanjivg saved
in the kanjivec object. Either a vector of length 2 specifying some fixed offset for
all numbers or a matrix of dimension kanjivec$nstrokes times 2.}

\item{family}{the font-family for labeling the nodes if \code{type = dend}. See details.}

\item{lwd}{the usual line width graphics parameter.}

\item{...}{further parameters passed to \code{lines} if \code{type = "kanji"} and to \code{plot.dendrogram}
if \code{type = "dend"}.}
}
\value{
No return value, called for side effects.
}
\description{
Plot kanjivec objects
}
\details{
Setting up nice labels for the nodes if \code{type = "dend"} is not easy. For many
font families it appears that some "kanji components" cannot be displayed in plots
even with the help of package \code{showtext} and if the
font contains glyphs for the corresponding codepoints that display correctly in text documents.
This concerns in increasing severity of the problem Unicode blocks 2F00–2FDF (Kangxi Radicals),
2E80–2EFF (CJK Radicals Supplement) and 31C0–31EF (CJK Strokes). For the strokes it seems
nearly impossible which is why leaves are simply annotated with the number of the strokes.

For the other it is up to the user to find a suitable font and pass it via the argument
font family. The default \code{family = NULL} first tries to use \code{default_font}
if this option has been set (via \code{\link{kanjistat_options}}) and otherwise
uses \code{wqy-microhei}, the Chinese default font that comes with package \code{showtext}
and cannot display any radicals from the supplement.

On a Mac the experience is that "hiragino_sans" works well. In addition there is the issue of
font size which is currently not judiciously set and may be too large for some (especially
on-screen) devices. The parameter \code{cex} (via \code{...}) fixes this.
}
\examples{
kanji <- fivebetas[[2]]
plot(kanji, type = "kanji", seg_depth = 2)
plot(kanji, type = "dend")  
  # gives a warning if get_kanjistat_option("default_font") is NULL

}
