% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/english_wrappers.R
\name{generate_world}
\alias{generate_world}
\title{Create Karel's world}
\usage{
generate_world(world)
}
\arguments{
\item{world}{Character vector of length 1 with the name of one of the
provided worlds in the package or a list provided by the user with all the
components that a world needs (see more below in details).}
}
\value{
Plots the initial state of Karel's world and prepares everything to
  start recording her actions.
}
\description{
This function takes a "world" (i.e. a list with data about its size, walls,
beepers and Karel's position and direction), plots it and prepares everything
so that Karel can start performing actions in it. It must be run always
before Karel starts working on her goals, especially if we have made a
mistake, we must start all over again by first running this function.
}
\details{
After running \code{generate_mundo()}, we can run Karel's actions and finally
visualize it all with the function \code{run_actions()}.

Argument \code{world} can be create by the user. In this case, it
  must be a list with the following components:

  \enumerate{
    \item \code{nx}: TODO
    \item \code{ny}:
    \item \code{hor_walls}:
    \item \code{ver_walls}:
    \item \code{karel_x}:
    \item \code{karel_y}:
    \item \code{karel_dir}:
    \item \code{beepers_x}:
    \item \code{beepers_y}:
    \item \code{beepers_n}:
    \item \code{beepers_bag}:
  }
}
\examples{
generate_world("mundo001")

}
\seealso{
\code{\link{actions}} \code{\link{run_actions}}
}
