% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTapestriExperiment.R
\name{createTapestriExperiment}
\alias{createTapestriExperiment}
\title{Create \code{TapestriExperiment} object from Tapestri Pipeline output}
\usage{
createTapestriExperiment(
  h5.filename,
  panel.id = NULL,
  get.cytobands = TRUE,
  genome = "hg19",
  move.non.genome.probes = TRUE,
  filter.variants = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{h5.filename}{File path for \code{.h5} file from Tapestri Pipeline output.}

\item{panel.id}{Character, Tapestri panel ID, either CO261, CO293, CO610, or \code{NULL}. Initializes \code{barcodeProbe} and \code{grnaProbe} slots. Default \code{NULL}.}

\item{get.cytobands}{Logical, if \code{TRUE} (default), retrieve and add chromosome cytobands and chromosome arms to \code{rowData} (probe metadata).}

\item{genome}{Character, reference genome for pulling cytoband coordinates and chromosome arm labels (see \code{\link[=getCytobands]{getCytobands()}}). Only "hg19" (default) is currently supported.}

\item{move.non.genome.probes}{Logical, if \code{TRUE} (default), move counts and metadata from non-genomic probes to \code{altExp} slots (see \code{\link[=moveNonGenomeProbes]{moveNonGenomeProbes()}}).}

\item{filter.variants}{Logical, if \code{TRUE} (default), only stores variants that have passed Tapestri Pipeline filters.}

\item{verbose}{Logical, if \code{TRUE} (default), metadata is output in message text.}
}
\value{
\code{TapestriExperiment} object containing data from Tapestri Pipeline output.
}
\description{
\code{createTapestriExperiment()} constructs a \code{TapestriExperiment} container object from data stored in the \code{.h5} file output by the Tapestri Pipeline.
Read count matrix (probe x cell barcode) is stored in the "counts" \code{assay} slot of the top-level experiment.
Allele frequency matrix (variant x cell barcode) is stored in the "alleleFrequency" \code{assay} slot of the "alleleFrequency" \code{altExp} (alternative experiment) slot.
\code{panel.id} is an optional shortcut to set special probe identities for specific custom panels.
}
\section{Panel ID Shortcuts}{
\code{panel.id} is an optional shortcut to set the \code{barcodeProbe} and \code{grnaProbe} slots in \code{TapestriExperiment} for specific custom Tapestri panels.
\subsection{CO261}{
\itemize{
\item \code{barcodeProbe} = "not specified"
\item \code{grnaProbe} = "not specified"
}
}

\subsection{CO293}{
\itemize{
\item \code{barcodeProbe} = "AMPL205334"
\item \code{grnaProbe} = "AMPL205666"
}
}

\subsection{CO610}{
\itemize{
\item \code{barcodeProbe} = "CO610_AMP351"
\item \code{grnaProbe} = "CO610_AMP350"
}
}
}

\section{Automatic Operations}{
\subsection{Raw Data}{

Read count and allele frequency matrices are imported to their appropriate slots as described above.
\code{filter.variants == TRUE} (default) only loads allele frequency variants that have passed internal filters in the Tapestri Pipeline.
This greatly reduces the number of variants from tens of thousands to hundreds of likely more consequential variants,
saving RAM and reducing operation time.
}

\subsection{Metadata}{

Several metadata sets are copied or generated and then stored in the appropriate \code{TapestriExperiment} slot during construction.
\itemize{
\item Probe panel metadata stored in the \code{.h5} file are copied to \code{rowData}.
\item Basic QC stats (e.g. total number of reads per probe) are added to \code{rowData.}
\item Basic QC stats (e.g. total number of reads per cell barcode) are added to \code{colData.}
\item Experiment-level metadata is stored in \code{metadata}.
}
}
}

\section{Optional Operations}{
Two additional major operations are called by default during \code{TapestriExperiment} construction for convenience.
\code{get.cytobands == TRUE} (default) calls \code{\link[=getCytobands]{getCytobands()}}, which retrieves the chromosome arm and cytoband for each probe based on stored positional data and saves them in \code{rowData}.
Some downstream smoothing and plotting functions may fail if chromosome arms are not present in \code{rowData}, so this generally should always be run.
\code{move.non.genome.probes} calls \code{\link[=moveNonGenomeProbes]{moveNonGenomeProbes()}}, which moves probes corresponding to the specified tags to \code{altExp} (alternative experiment) slots in the \code{TapestriExperiment} object.
The exception is probes on chromosome Y; CNVs of chrY are more rare, so we move it to an \code{altExp} for separate analysis.
Probes corresponding to the \code{barcodeProbe} and \code{grnaProbe} slots, which are specified by the \code{panel.id} shortcut or manually (see \link{Custom Slot Getters and Setters}),
are automatically moved to \code{altExp} by this operation as well.
If such probes are not present, the function will only generate a warning message, so it is always safe (and recommended) to run by default.
Any remaining probes that are not targeting a human chromosome and are not specified by the shortcut tags are moved to the \code{otherProbeCounts} slot.
}

\examples{
\dontrun{
tapExperiment <- createTapestriExperiment("myh5file.h5", "CO293")
}
}
\seealso{
\code{\link[=moveNonGenomeProbes]{moveNonGenomeProbes()}}, \code{\link[=getCytobands]{getCytobands()}}, which are run as part of this function by default.
}
\concept{build experiment}
