% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-normalization.R
\name{layer_batch_normalization}
\alias{layer_batch_normalization}
\title{Batch normalization layer (Ioffe and Szegedy, 2014).}
\usage{
layer_batch_normalization(object, axis = -1L, momentum = 0.99,
  epsilon = 0.001, center = TRUE, scale = TRUE,
  beta_initializer = "zeros", gamma_initializer = "ones",
  moving_mean_initializer = "zeros", moving_variance_initializer = "ones",
  beta_regularizer = NULL, gamma_regularizer = NULL,
  beta_constraint = NULL, gamma_constraint = NULL, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{axis}{Integer, the axis that should be normalized (typically the
features axis). For instance, after a \code{Conv2D} layer with
\code{data_format="channels_first"}, set \code{axis=1} in \code{BatchNormalization}.}

\item{momentum}{Momentum for the moving mean and the moving variance.}

\item{epsilon}{Small float added to variance to avoid dividing by zero.}

\item{center}{If TRUE, add offset of \code{beta} to normalized tensor. If FALSE,
\code{beta} is ignored.}

\item{scale}{If TRUE, multiply by \code{gamma}. If FALSE, \code{gamma} is not used.
When the next layer is linear (also e.g. \code{nn.relu}), this can be disabled
since the scaling will be done by the next layer.}

\item{beta_initializer}{Initializer for the beta weight.}

\item{gamma_initializer}{Initializer for the gamma weight.}

\item{moving_mean_initializer}{Initializer for the moving mean.}

\item{moving_variance_initializer}{Initializer for the moving variance.}

\item{beta_regularizer}{Optional regularizer for the beta weight.}

\item{gamma_regularizer}{Optional regularizer for the gamma weight.}

\item{beta_constraint}{Optional constraint for the beta weight.}

\item{gamma_constraint}{Optional constraint for the gamma weight.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Normalize the activations of the previous layer at each batch, i.e. applies a
transformation that maintains the mean activation close to 0 and the
activation standard deviation close to 1.
}
\section{Input shape}{
 Arbitrary. Use the keyword argument \code{input_shape} (list
of integers, does not include the samples axis) when using this layer as
the first layer in a model.
}

\section{Output shape}{
 Same shape as input.
}

\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1502.03167}{Batch Normalization: Accelerating Deep Network Training by Reducing Internal Covariate Shift}
}
}

