% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{image_load}
\alias{image_load}
\title{Loads an image into PIL format.}
\usage{
image_load(
  path,
  grayscale = FALSE,
  color_mode = "rgb",
  target_size = NULL,
  interpolation = "nearest"
)
}
\arguments{
\item{path}{Path to image file}

\item{grayscale}{DEPRECATED use \code{color_mode="grayscale"}}

\item{color_mode}{One of \verb{\{"grayscale", "rgb", "rgba"\}}.
Default: \code{"rgb"}. The desired image format.}

\item{target_size}{Either \code{NULL} (default to original size) or integer vector
\verb{(img_height, img_width)}.}

\item{interpolation}{Interpolation method used to resample the image if the
target size is different from that of the loaded image. Supported methods
are "nearest", "bilinear", and "bicubic". If PIL version 1.1.3 or newer is
installed, "lanczos" is also supported. If PIL version 3.4.0 or newer is
installed, "box" and "hamming" are also supported. By default, "nearest"
is used.}
}
\value{
A PIL Image instance.
}
\description{
Loads an image into PIL format.
}
\seealso{
Other image preprocessing: 
\code{\link{fit_image_data_generator}()},
\code{\link{flow_images_from_data}()},
\code{\link{flow_images_from_dataframe}()},
\code{\link{flow_images_from_directory}()},
\code{\link{image_to_array}()}
}
\concept{image preprocessing}
