% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_model_checkpoint}
\alias{callback_model_checkpoint}
\title{Save the model after every epoch.}
\usage{
callback_model_checkpoint(filepath, monitor = "val_loss", verbose = 0,
  save_best_only = FALSE, save_weights_only = FALSE, mode = c("auto",
  "min", "max"), period = 1)
}
\arguments{
\item{filepath}{string, path to save the model file.}

\item{monitor}{quantity to monitor.}

\item{verbose}{verbosity mode, 0 or 1.}

\item{save_best_only}{if \code{save_best_only=TRUE}, the latest best model
according to the quantity monitored will not be overwritten.}

\item{save_weights_only}{if \code{TRUE}, then only the model's weights will be
saved (\code{save_model_weights_hdf5(filepath)}), else the full model is saved
(\code{save_model_hdf5(filepath)}).}

\item{mode}{one of "auto", "min", "max". If \code{save_best_only=TRUE}, the decision to
overwrite the current save file is made based on either the maximization or
the minimization of the monitored quantity. For val_acc, this should be
max, for val_loss this should be min, etc. In auto mode, the direction is
automatically inferred from the name of the monitored quantity.}

\item{period}{Interval (number of epochs) between checkpoints.}
}
\description{
\code{filepath} can contain named formatting options, which will be filled the
value of \code{epoch} and keys in \code{logs} (passed in \code{on_epoch_end}). For example:
if \code{filepath} is \code{weights.{epoch:02d}-{val_loss:.2f}.hdf5}, then the model
checkpoints will be saved with the epoch number and the validation loss in
the filename.
}
\section{For example}{
 if \code{filepath} is
\code{weights.{epoch:02d}-{val_loss:.2f}.hdf5},: then the model checkpoints will
be saved with the epoch number and the validation loss in the filename.
}

\seealso{
Other callbacks: \code{\link{callback_csv_logger}},
  \code{\link{callback_early_stopping}},
  \code{\link{callback_lambda}},
  \code{\link{callback_learning_rate_scheduler}},
  \code{\link{callback_progbar_logger}},
  \code{\link{callback_reduce_lr_on_plateau}},
  \code{\link{callback_remote_monitor}},
  \code{\link{callback_tensorboard}},
  \code{\link{callback_terminate_on_naan}}
}
\concept{callbacks}
