% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_maximum}
\alias{layer_maximum}
\title{Layer that computes the maximum (element-wise) a list of inputs.}
\usage{
layer_maximum(inputs, batch_size = NULL, dtype = NULL, name = NULL,
  trainable = NULL, weights = NULL)
}
\arguments{
\item{inputs}{A list of input tensors (at least 2).}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\value{
A tensor, the element-wise maximum of the inputs.
}
\description{
It takes as input a list of tensors, all of the same shape, and returns a
single tensor (also of the same shape).
}
\seealso{
Other merge layers: \code{\link{layer_add}},
  \code{\link{layer_average}},
  \code{\link{layer_concatenate}}, \code{\link{layer_dot}},
  \code{\link{layer_minimum}},
  \code{\link{layer_multiply}},
  \code{\link{layer_subtract}}
}
\concept{merge layers}
