% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{serialize_model}
\alias{serialize_model}
\alias{unserialize_model}
\title{Serialize a model to an R object}
\usage{
serialize_model(model, include_optimizer = TRUE)

unserialize_model(model, custom_objects = NULL, compile = TRUE)
}
\arguments{
\item{model}{Keras model or R "raw" object containing serialized Keras model.}

\item{include_optimizer}{If \code{TRUE}, save optimizer's state.}

\item{custom_objects}{Mapping class names (or function names) of custom
(non-Keras) objects to class/functions (for example, custom metrics
or custom loss functions).}

\item{compile}{Whether to compile the model after loading.}
}
\value{
\code{serialize_model()} returns an R "raw" object containing an hdf5
version of the Keras model. \code{unserialize_model()} returns a Keras model.
}
\description{
Model objects are external references to Keras objects which cannot be saved
and restored across R sessions. The \code{serialize_model()} and
\code{unserialize_model()} functions provide facilities to convert Keras models to
R objects for persistence within R data files.
}
\note{
The \code{\link[=save_model_hdf5]{save_model_hdf5()}} function enables saving Keras models to
external hdf5 files.
}
\seealso{
Other model persistence: \code{\link{get_weights}},
  \code{\link{model_to_json}}, \code{\link{model_to_yaml}},
  \code{\link{save_model_hdf5}},
  \code{\link{save_model_weights_hdf5}}
}
\concept{model persistence}
