% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_batch_normalization}
\alias{k_batch_normalization}
\title{Applies batch normalization on x given mean, var, beta and gamma.}
\usage{
k_batch_normalization(x, mean, var, beta, gamma, axis = -1, epsilon = 0.001)
}
\arguments{
\item{x}{Input tensor or variable.}

\item{mean}{Mean of batch.}

\item{var}{Variance of batch.}

\item{beta}{Tensor with which to center the input.}

\item{gamma}{Tensor by which to scale the input.}

\item{axis}{Axis (axis indexes are 1-based). Pass -1 (the
default) to select the last axis.}

\item{epsilon}{Fuzz factor.}
}
\value{
A tensor.
}
\description{
i.e. returns
\code{output <- (x - mean) / (sqrt(var) + epsilon) * gamma + beta}
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

