% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_sparse_categorical_accuracy}
\alias{metric_sparse_categorical_accuracy}
\title{Calculates how often predictions match integer labels}
\usage{
metric_sparse_categorical_accuracy(
  y_true,
  y_pred,
  ...,
  name = "sparse_categorical_accuracy",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor of true targets.}

\item{y_pred}{Tensor of predicted targets.}

\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
If \code{y_true} and \code{y_pred} are missing, a (subclassed) \code{Metric}
instance is returned. The \code{Metric} object can be passed directly to
\code{compile(metrics = )} or used as a standalone object. See \code{?Metric} for
example usage.

Alternatively, if called with \code{y_true} and \code{y_pred} arguments, then the
computed case-wise values for the mini-batch are returned directly.
}
\description{
Calculates how often predictions match integer labels
}
\details{
\if{html}{\out{<div class="r">}}\preformatted{acc = k_dot(sample_weight, y_true == k_argmax(y_pred, axis=2))
}\if{html}{\out{</div>}}

You can provide logits of classes as \code{y_pred}, since argmax of
logits and probabilities are same.

This metric creates two local variables, \code{total} and \code{count} that are used to
compute the frequency with which \code{y_pred} matches \code{y_true}. This frequency is
ultimately returned as \verb{sparse categorical accuracy}: an idempotent operation
that simply divides \code{total} by \code{count}.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_mean}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_precision}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_recall}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
