% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{text_dataset_from_directory}
\alias{text_dataset_from_directory}
\title{Generate a \code{tf.data.Dataset} from text files in a directory}
\usage{
text_dataset_from_directory(
  directory,
  labels = "inferred",
  label_mode = "int",
  class_names = NULL,
  batch_size = 32L,
  max_length = NULL,
  shuffle = TRUE,
  seed = NULL,
  validation_split = NULL,
  subset = NULL,
  follow_links = FALSE,
  ...
)
}
\arguments{
\item{directory}{Directory where the data is located.
If \code{labels} is "inferred", it should contain
subdirectories, each containing text files for a class.
Otherwise, the directory structure is ignored.}

\item{labels}{Either "inferred"
(labels are generated from the directory structure),
NULL (no labels),
or a list of integer labels of the same size as the number of
text files found in the directory. Labels should be sorted according
to the alphanumeric order of the text file paths
(obtained via \code{os.walk(directory)} in Python).}

\item{label_mode}{\itemize{
\item \code{'int'}: means that the labels are encoded as integers
(e.g. for \code{sparse_categorical_crossentropy} loss).
\item \code{'categorical'} means that the labels are
encoded as a categorical vector
(e.g. for \code{categorical_crossentropy} loss).
\item \code{'binary'} means that the labels (there can be only 2)
are encoded as \code{float32} scalars with values 0 or 1
(e.g. for \code{binary_crossentropy}).
\item \code{NULL} (no labels).
}}

\item{class_names}{Only valid if \code{labels} is \code{"inferred"}. This is the explicit
list of class names (must match names of subdirectories). Used
to control the order of the classes
(otherwise alphanumerical order is used).}

\item{batch_size}{Size of the batches of data. Default: \code{32}.}

\item{max_length}{Maximum size of a text string. Texts longer than this will
be truncated to \code{max_length}.}

\item{shuffle}{Whether to shuffle the data. Default: \code{TRUE}.
If set to \code{FALSE}, sorts the data in alphanumeric order.}

\item{seed}{Optional random seed for shuffling and transformations.}

\item{validation_split}{Optional float between 0 and 1,
fraction of data to reserve for validation.}

\item{subset}{One of "training" or "validation".
Only used if \code{validation_split} is set.}

\item{follow_links}{Whether to visits subdirectories pointed to by symlinks.
Defaults to \code{FALSE}.}

\item{...}{For future compatibility (unused presently).}
}
\description{
Generate a \code{tf.data.Dataset} from text files in a directory
}
\details{
If your directory structure is:\preformatted{main_directory/
...class_a/
......a_text_1.txt
......a_text_2.txt
...class_b/
......b_text_1.txt
......b_text_2.txt
}

Then calling \code{text_dataset_from_directory(main_directory, labels = 'inferred')}
will return a \code{tf.data.Dataset} that yields batches of texts from
the subdirectories \code{class_a} and \code{class_b}, together with labels
0 and 1 (0 corresponding to \code{class_a} and 1 corresponding to \code{class_b}).

Only \code{.txt} files are supported at this time.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/utils/text_dataset_from_directory}
}
}
