% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_inception_resnet_v2}
\alias{application_inception_resnet_v2}
\alias{inception_resnet_v2_preprocess_input}
\title{Inception-ResNet v2 model, with weights trained on ImageNet}
\usage{
application_inception_resnet_v2(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000,
  classifier_activation = "softmax",
  ...
)

inception_resnet_v2_preprocess_input(x)
}
\arguments{
\item{include_top}{Whether to include the fully-connected
layer at the top of the network. Defaults to \code{TRUE}.}

\item{weights}{One of \code{NULL} (random initialization),
\code{'imagenet'} (pre-training on ImageNet),
or the path to the weights file to be loaded. Defaults to \code{'imagenet'}.}

\item{input_tensor}{Optional Keras tensor
(i.e. output of \code{layer_input()})
to use as image input for the model.}

\item{input_shape}{optional shape list, only to be specified
if \code{include_top} is FALSE (otherwise the input shape
has to be \verb{(299, 299, 3)}.
It should have exactly 3 inputs channels,
and width and height should be no smaller than 71.
E.g. \verb{(150, 150, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}. Defaults to \code{NULL}.
\itemize{
\item \code{NULL} means that the output of the model will be
the 4D tensor output of the
last convolutional layer.
\item \code{'avg'} means that global average pooling
will be applied to the output of the
last convolutional layer, and thus
the output of the model will be a 2D tensor.
\item \code{'max'} means that global max pooling will
be applied.
}}

\item{classes}{Optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified. Defaults to 1000 (number of ImageNet classes).}

\item{classifier_activation}{A string or callable. The activation function to
use on the "top" layer. Ignored unless \code{include_top = TRUE}. Set
\code{classifier_activation = NULL} to return the logits of the "top" layer.
Defaults to \code{'softmax'}. When loading pretrained weights,
\code{classifier_activation} can only be \code{NULL} or \code{"softmax"}.}

\item{...}{For backwards and forwards compatibility}

\item{x}{\code{preprocess_input()} takes an array or floating point tensor, 3D or
4D with 3 color channels, with values in the range \verb{[0, 255]}.}
}
\value{
A Keras model instance.
}
\description{
Inception-ResNet v2 model, with weights trained on ImageNet
}
\details{
Do note that the input image format for this model is different than for
the VGG16 and ResNet models (299x299 instead of 224x224).

The \code{inception_resnet_v2_preprocess_input()} function should be used for image
preprocessing.
}
\section{Reference}{

\itemize{
\item \href{https://arxiv.org/abs/1602.07261}{Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}(https://arxiv.org/abs/1512.00567)
}
}

