% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_hard_sigmoid}
\alias{activation_hard_sigmoid}
\title{Hard sigmoid activation function.}
\usage{
activation_hard_sigmoid(x)
}
\arguments{
\item{x}{Input tensor.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The hard sigmoid activation is defined as:
\itemize{
\item \code{0} if \verb{if x < -2.5}
\item \code{1} if \code{x > 2.5}
\item \code{0.2 * x + 0.5} if \verb{-2.5 <= x <= 2.5}
}

It's a faster, piecewise linear approximation
of the sigmoid activation.
}
\section{Reference}{
\itemize{
\item \href{https://en.wikipedia.org/wiki/Hard_sigmoid}{Wikipedia "Hard sigmoid"}
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#hardsigmoid-function}
}

Other activations: \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_tanh}()} \cr
}
\concept{activations}
