% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{test_on_batch}
\alias{test_on_batch}
\title{Test the model on a single batch of samples.}
\usage{
test_on_batch(object, x, y = NULL, sample_weight = NULL, ...)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data. Must be array-like.}

\item{y}{Target data. Must be array-like.}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample.
In the case of temporal data, you can pass a 2D array
with shape \verb{(samples, sequence_length)}, to apply a different
weight to every timestep of every sample.}

\item{...}{for forward/backward compatability}
}
\value{
A scalar loss value (when no metrics),
or a named list of loss and metric values
(if there are metrics).
}
\description{
Test the model on a single batch of samples.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_training_apis#testonbatch-method}
}

Other model training: \cr
\code{\link{compile.keras.src.models.model.Model}()} \cr
\code{\link{evaluate.keras.src.models.model.Model}()} \cr
\code{\link{predict.keras.src.models.model.Model}()} \cr
\code{\link{predict_on_batch}()} \cr
\code{\link{train_on_batch}()} \cr
}
\concept{model training}
