% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_gelu}
\alias{activation_gelu}
\title{Gaussian error linear unit (GELU) activation function.}
\usage{
activation_gelu(x, approximate = FALSE)
}
\arguments{
\item{x}{Input tensor.}

\item{approximate}{A \code{bool}, whether to enable approximation.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The Gaussian error linear unit (GELU) is defined as:

\code{gelu(x) = x * P(X <= x)} where \code{P(X) ~ N(0, 1)},
i.e. \code{gelu(x) = 0.5 * x * (1 + erf(x / sqrt(2)))}.

GELU weights inputs by their value, rather than gating
inputs by their sign as in ReLU.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1606.08415}{Hendrycks et al., 2016}
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/activations#gelu-function}
}

Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
