% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{Sequential}
\alias{Sequential}
\title{Initialize sequential model}
\usage{
Sequential(...)
}
\arguments{
\item{...}{keras model layers to construct the
model from}
}
\description{
Use this function to construct an empty model to which
layers will be added, or pass a list of layers directly
to the function. The first layer passed to a Sequential
model should have a defined input shape.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(  Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  # You can also add layers directly as arguments to Sequential()

  mod <- Sequential(
    Dense(units = 50, input_shape = ncol(X_train)),
    Dropout(rate = 0.5),
    Activation("relu"),
    Dense(units = 3),
    ActivityRegularization(l1 = 1),
    Activation("softmax")
  )
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
}

}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other model functions: \code{\link{LoadSave}},
  \code{\link{Predict}}, \code{\link{keras_compile}},
  \code{\link{keras_fit}}

Other layers: \code{\link{Activation}},
  \code{\link{ActivityRegularization}},
  \code{\link{AdvancedActivation}},
  \code{\link{BatchNormalization}}, \code{\link{Conv}},
  \code{\link{Dense}}, \code{\link{Dropout}},
  \code{\link{Embedding}}, \code{\link{Flatten}},
  \code{\link{GaussianNoise}}, \code{\link{LayerWrapper}},
  \code{\link{LocallyConnected}}, \code{\link{Masking}},
  \code{\link{MaxPooling}}, \code{\link{Permute}},
  \code{\link{RNN}}, \code{\link{RepeatVector}},
  \code{\link{Reshape}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
