% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extractors}
\alias{extractors}
\alias{ks_shap_values}
\alias{ks_shap_values.kernelshap}
\alias{ks_shap_values.default}
\alias{ks_feature_values}
\alias{ks_feature_values.kernelshap}
\alias{ks_feature_values.default}
\alias{ks_baseline}
\alias{ks_baseline.kernelshap}
\alias{ks_baseline.default}
\alias{ks_standard_errors}
\alias{ks_standard_errors.kernelshap}
\alias{ks_standard_errors.default}
\alias{ks_n_iter}
\alias{ks_n_iter.kernelshap}
\alias{ks_n_iter.default}
\alias{ks_converged}
\alias{ks_converged.kernelshap}
\alias{ks_converged.default}
\title{Extractor Functions}
\usage{
ks_shap_values(object, ...)

\method{ks_shap_values}{kernelshap}(object, ...)

\method{ks_shap_values}{default}(object, ...)

ks_feature_values(object, ...)

\method{ks_feature_values}{kernelshap}(object, ...)

\method{ks_feature_values}{default}(object, ...)

ks_baseline(object, ...)

\method{ks_baseline}{kernelshap}(object, ...)

\method{ks_baseline}{default}(object, ...)

ks_standard_errors(object, ...)

\method{ks_standard_errors}{kernelshap}(object, ...)

\method{ks_standard_errors}{default}(object, ...)

ks_n_iter(object, ...)

\method{ks_n_iter}{kernelshap}(object, ...)

\method{ks_n_iter}{default}(object, ...)

ks_converged(object, ...)

\method{ks_converged}{kernelshap}(object, ...)

\method{ks_converged}{default}(object, ...)
}
\arguments{
\item{object}{Object to extract something.}

\item{...}{Currently unused.}
}
\value{
The corresponding object is returned, i.e.,
\itemize{
\item \code{ks_shap_values()} returns the matrix of SHAP values,
\item \code{ks_feature_values()} the \code{data.frame} of feature values,
\item \code{ks_baseline()} the numeric baseline value of the input,
\item \code{ks_standard_errors()} the matrix of standard errors of SHAP values,
\item \code{ks_converged()} returns the vector of convergence flags, and finally
\item \code{ks_n_iter()} the number of iterations per row.
}
}
\description{
Functions to extract SHAP values, feature values, standard errors etc. from a "kernelshap" object.
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
pred_fun <- function(X) stats::predict(fit, X)
s <- kernelshap(iris[1:2, -1], pred_fun = pred_fun, iris[-1])
ks_shap_values(s)
}
