% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additive_shap.R
\name{additive_shap}
\alias{additive_shap}
\title{Additive SHAP}
\usage{
additive_shap(object, X, verbose = TRUE, ...)
}
\arguments{
\item{object}{Fitted model object.}

\item{X}{Dataframe with rows to be explained. Will be used like
\code{predict(object, newdata = X, type = "terms")}.}

\item{verbose}{Set to \code{FALSE} to suppress messages and the progress bar.}

\item{...}{Currently unused.}
}
\value{
An object of class "kernelshap" with the following components:
\itemize{
\item \code{S}: \eqn{(n \times p)} matrix with SHAP values.
\item \code{X}: Same as input argument \code{X}.
\item \code{baseline}: The baseline.
\item \code{exact}: \code{TRUE}.
\item \code{txt}: Summary text.
\item \code{predictions}: Vector with predictions of \code{X} on the scale of "terms".
\item \code{algorithm}: "additive_shap".
}
}
\description{
Exact additive SHAP assuming feature independence. The implementation
works for models fitted via
\itemize{
\item \code{\link[=lm]{lm()}},
\item \code{\link[=glm]{glm()}},
\item \code{\link[mgcv:gam]{mgcv::gam()}},
\item \code{\link[mgcv:bam]{mgcv::bam()}},
\item \code{gam::gam()},
\item \code{\link[survival:coxph]{survival::coxph()}}, and
\item \code{\link[survival:survreg]{survival::survreg()}}.
}
}
\details{
The SHAP values are extracted via \code{predict(object, newdata = X, type = "terms")},
a logic heavily inspired by \code{fastshap:::explain.lm(..., exact = TRUE)}.
Models with interactions (specified via \code{:} or \code{*}), or with terms of
multiple features like \code{log(x1/x2)} are not supported.

Note that the SHAP values obtained by \code{\link[=additive_shap]{additive_shap()}} are expected to
match those of \code{\link[=permshap]{permshap()}} and \code{\link[=kernelshap]{kernelshap()}} as long as their background
data equals the full training data (which is typically not feasible).
}
\examples{
# MODEL ONE: Linear regression
fit <- lm(Sepal.Length ~ ., data = iris)
s <- additive_shap(fit, head(iris))
s

# MODEL TWO: More complicated (but not very clever) formula
fit <- lm(
  Sepal.Length ~ poly(Sepal.Width, 2) + log(Petal.Length) + log(Sepal.Width),
  data = iris
)
s_add <- additive_shap(fit, head(iris))
s_add

# Equals kernelshap()/permshap() when background data is full training data
s_kernel <- kernelshap(
 fit, head(iris[c("Sepal.Width", "Petal.Length")]), bg_X = iris
)
all.equal(s_add$S, s_kernel$S)
}
